% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair-value-data.R
\name{convert-pair-value}
\alias{convert-pair-value}
\alias{long_to_mat}
\alias{mat_to_long}
\title{Convert between long pair-value data and matrix}
\usage{
long_to_mat(tbl, row_key, col_key, value = NULL, fill = NULL, silent = FALSE)

mat_to_long(mat, row_key, col_key, value, drop = FALSE)
}
\arguments{
\item{tbl}{Data frame with pair-value data.}

\item{row_key}{String name of column for first key in pair.}

\item{col_key}{String name of column for second key in pair.}

\item{value}{String name of column for value (or \code{NULL} for \code{long_to_mat()}).}

\item{fill}{Value to fill for missing pairs.}

\item{silent}{Use \code{TRUE} to omit message about guessed value column (see
Details).}

\item{mat}{Matrix with pair-value data.}

\item{drop}{Use \code{TRUE} to drop rows with missing value (see Details).}
}
\value{
\code{long_to_mat()} returns a matrix with selected values where row names
indicate first key in pair, col names - second.

\code{mat_to_long()} returns a \code{tibble} with three columns: the
one for first key in pair, the one for second, and the one for value.
}
\description{
Functions for conversion between long pair-value data (data frame with
columns for pair identifiers and value column) and matrix.
}
\details{
Pair-value data is commonly used in description of pairs of objects.
Pair is described by two keys (usually integer or character) and value is an
object of arbitrary nature.

In \strong{long format} there are at least three columns: for first key in pair,
for second key and for value (might be more). In \strong{matrix format} pair-value
data is represented as matrix of values with row names as character
representation of first key, column names - second key.

\code{long_to_mat()} works as follows:
\itemize{
\item Pair identifiers are taken from columns with names \code{row_key} (to be used as
row names) and \code{col_key} (to be used as column names). Unique identifiers
(and future dimension names) are determined with \code{\link[=levels2]{levels2()}}. This is a way
to target function on specific set of pairs by using factor columns. \strong{Note}
that \code{NA}s are treated as single unknown key and put on last place (in case
of non-factor).
\item Values are taken from column with name \code{value}. \strong{Note} that if \code{value}
has length 0 (typically \code{NULL}) then \code{long_to_mat()} will take first
non-key column. If there is no such column, it will use vector of dummy
values (\code{NA}s or \code{fill}s). In both cases a message is given if \code{silent = FALSE}.
\item Output is a matrix with described row and column names. Value of pair
"key_1" and "key_2" is stored at intersection of row "key_1" and "key_2".
\strong{Note} that in case of duplicated pairs the value from first occurrence is
taken.
}

\code{mat_to_long()} basically performs inverse operation to \code{long_to_mat()} but
pair identifiers are always character. If \code{drop = TRUE} it drops rows with
values (but not keys) being missing.
}
\examples{
long_data <- data.frame(
  key_1 = c("a", "a", "b"),
  key_2 = c("c", "d", "c"),
  val = 1:3,
  stringsAsFactors = FALSE
)

mat_data <- long_data \%>\% long_to_mat("key_1", "key_2", "val")
print(mat_data)

# Converts to tibble
mat_data \%>\% mat_to_long("new_key_1", "new_key_2", "new_val")

# Drops rows with valuus missing
mat_data \%>\% mat_to_long("new_key_1", "new_key_2", "new_val", drop = TRUE)

}
