% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffexp.R
\name{ffexp}
\alias{ffexp}
\title{Full factorial experiment}
\description{
A class for easily creating and evaluating full factorial experiments.
}
\section{Usage}{

\preformatted{
e1 <- ffexp$new(eval_func=, )

e1$run_all()

e1$plot_run_times()

e1$save_self()

}
}

\section{Arguments}{

\code{eval_func} The function called to evaluate each design point.

\code{...} Factors and their levels to be evaluated at.

\code{save_output} Should the output be saved?

\code{parallel} If \code{TRUE}, function evaluations are done in parallel.

\code{parallel_cores} Number of cores to be used in parallel.
If \code{"detect"}, \code{parallel::detectCores()} is used to determine
number. \code{"detect-1"} may be used so that the computer isn't running
at full capacity, which can slow down other tasks.
}

\section{Methods}{

\code{$new()} Initialize an experiment. The preprocessing is done,
but no function evaluations are run.

\code{$run_all()} Run all factor combinations.

\code{$run_one()} Run a single factor combination.

\code{$add_result_of_one()} Used to add result of evaluation to data set,
don't manually call.

\code{$plot_run_times()} Plot the run times. Especially useful when
they have been run in parallel.

\code{$save_self()} Save ffexp R6 object.

\code{$recover_parallel_temp_save()} If you ran the experiment using
parallel with \code{parallel_temp_save=TRUE} and it crashes partway
through, call this to recover the runs that were completed.
Runs that were stopped mid-execution are not recoverable.
}

\examples{
# Two factors, both with two levels.
#   The evaluation function simply prints out the combination
cc <- ffexp$new(a=1:2,b=c("A","B"),
                eval_func=function(...) {c(...)})
# View the factor settings it will run (each row).
cc$rungrid
# Evaluate all four settings
cc$run_all()


cc <- ffexp$new(a=1:3,b=2, cd=data.frame(c=3:4,d=5:6),
                eval_func=function(...) {list(...)})
}
