% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comet.R
\name{comet}
\alias{comet}
\alias{comets}
\title{Covariance measure tests with formula interface}
\usage{
comet(formula, data, test = c("gcm", "pcm", "wgcm"), ...)

comets(formula, data, test = c("gcm", "pcm", "wgcm"), ...)
}
\arguments{
\item{formula}{Formula of the form \code{Y ~ X | Z} for testing Y independent
of X given Z.}

\item{data}{Data.frame containing the variables in \code{formula}.}

\item{test}{Character string; \code{"gcm"}, \code{"pcm"}, or \code{"wgcm"}.}

\item{...}{Additional arguments passed to \code{test}.}
}
\value{
Object of class \code{"gcm"}, \code{"wgcm"} or \code{"pcm"} and
    \code{"htest"}. See \code{\link{gcm}} and \code{\link{pcm}} for details.
}
\description{
Covariance measure tests with formula interface
}
\details{
Formula-based interface for the generalised and projected covariance measure
tests.
}
\examples{
tn <- 1e2
df <- data.frame(y = rnorm(tn), x1 = rnorm(tn), x2 = rnorm(tn), z = rnorm(tn))
comet(y ~ x1 + x2 | z, data = df, test = "gcm")

}
\references{
Kook, L. & Lundborg A. R. (2024). Algorithm-agnostic significance testing in
supervised learning with multimodal data. Briefings in Bioinformatics,
25(6), 2024. \doi{10.1093/bib/bbae475}
}
