% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary_colorDF}
\alias{summary_colorDF}
\alias{summary.colorDF}
\title{Meaningful summary of lists and data frames}
\usage{
summary_colorDF(
  object,
  numformat = "quantiles",
  digits = 3,
  width = getOption("width")
)

\method{summary}{colorDF}(object, ...)
}
\arguments{
\item{object}{a data frame (possibly a color data frame)}

\item{numformat}{format of the summary for numerical values. Can be one
of "quantiles", "mean" and "graphics"}

\item{digits}{number of significant digits to show (default: 3)}

\item{width}{width of the summary table in characters}

\item{...}{passed to \code{summary_colorDF}}
}
\value{
A colorful data frame of class colorDF containing useful
information on a dataframe-like object.
}
\description{
Meaningful, row-wise summary function for lists and data frames
}
\details{
While this function is a summary method for objects of the colorDF
class, it can also be applied to any other data frame-like object.

The summary table has five columns and as many rows as there are columns
in the summarized data frame (or elements in a list). First four columns contain, respectively,
column name, column class (abbreviated as in \link[tibble:tibble]{tibbles}),
number of unique values
and number of missing values (\code{NA}'s). The contents of the fifth column depends on the
column class and column type as follows:
\itemize{
\item first, any lists are unlisted
\item numeric columns (including integers) are summarized (see below)
\item for character vectors and factors, if all values are unique or missing (NA) then this
is stated explicitely
\item otherwise, for character vectors and factors, the values will be listed, starting with the most
frequent. The list will be shortened to fit the screen.
}

For numeric columns, by default the quantiles 0 (minimum), .25, .50 (median), .75
and 1 (maximum) are shown. Following alternatives can be specified using
the option \code{numformat}:
\itemize{
\item "mean": mean +- standard deviation
\item "graphics": a graphical summary. Note that all numerical columns will
be scaled with the same parameter, so this option makes sense only if the
numerical columns are comparable. The graphics summary looks like
this: ---|  +  |---- and corresponds to a regular box plot, indicating the
extremes and the three quartiles (- ... - indicates the data range, |...| the
interquartile range and '+' stands for the median).
}

\code{summary_colorDF} is the exported version of this function to facilitate
usage in cases when converting an object to a colorDF is not desirable.
}
\examples{
summary(colorDF(iris))
summary_colorDF(iris)
summary_colorDF(iris, numformat="g")
if(require(dplyr) && require(tidyr)) {
  starwars \%>\% summary_colorDF

  ## A summary of iris data by species
  iris \%>\% 
    mutate(row=rep(1:50, 3)) \%>\% 
    gather(key="parameter", value="Size", 1:4)  \%>\%
    mutate(pa.sp=paste(parameter, Species, sep=".")) \%>\% 
    select(row, pa.sp, Size) \%>\% 
    spread(key=pa.sp, value=Size) \%>\% 
    select(-row) \%>\%
    summary_colorDF(numformat="g")
}
}
