% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R, R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,colocTWAS,missing-method}
\alias{plot,coloc,missing-method}
\alias{plot,coloc,missing-method}
\alias{plot,colocABF,missing-method}
\alias{plot,coloc,missing-method}
\alias{plot,colocPCs,missing-method}
\alias{abf.plot}
\title{Plotting functions for the coloc package}
\usage{
plot(x, y, ...)

\S4method{plot}{colocTWAS,missing}(x)

\S4method{plot}{coloc,missing}(x, y, ...)

\S4method{plot}{colocABF,missing}(x, y, ...)

\S4method{plot}{coloc,missing}(x, y, ...)

\S4method{plot}{colocPCs,missing}(x)

abf.plot(coloc.obj, Pos = 1:nrow(coloc.obj@results), chr = NULL,
  pos.start = min(Pos), pos.end = max(Pos), trait1 = "trait 1",
  trait2 = "trait 2")
}
\arguments{
\item{x}{object to be plotted}

\item{y}{ignored}

\item{...}{other arguments}

\item{coloc.obj}{object of class \code{colocABF} returned by coloc.abf()}

\item{Pos}{positions of all snps in ds1 or in ds2}

\item{chr}{Chromosome}

\item{pos.start}{lower bound of positions}

\item{pos.end}{upper bound of positions}

\item{trait1}{name of trait 1}

\item{trait2}{name of trait 2}
}
\value{
no return value

a ggplot object
}
\description{
You can plot objects of class \code{coloc}, \code{colocBayes} and \code{colocABF}

Plot results of a coloc.abf run
}
\details{
If coloc.obj is missing, it will be created as coloc.obj=coloc.abf(ds1,ds2).  Both ds1 and ds2 should contain the same snps in the same order
}
\author{
Hui Guo, Chris Wallace
}
