% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cramer_v.R
\name{cramer_v}
\alias{cramer_v}
\title{Bias Corrected Cramer's V}
\usage{
cramer_v(x = NULL, y = NULL, check_input = TRUE)
}
\arguments{
\item{x}{(required; character vector) character vector representing a categorical variable.  Default: NULL}

\item{y}{(required; character vector) character vector representing a categorical variable. Must have the same length as 'x'. Default: NULL}

\item{check_input}{(required; logical) If FALSE, disables data checking for a slightly faster execution. Default: TRUE}
}
\value{
Numeric, value of Cramer's V
}
\description{
The \code{\link[=cramer_v]{cramer_v()}} function calculates bias-corrected Cramer's V, a measure of association between two categorical variables.

Cramer's V is an extension of the chi-squared test to measure the strength of association between two categorical variables. Provides values between 0 and 1, where 0 indicates no association, and 1 indicates a perfect association. In essence, Cramer's V assesses the co-occurrence of the categories of two variables to quantify how strongly these variables are related.

Even when its range is between 0 and 1, Cramer's V values are not directly comparable to R-squared values, and as such, a multicollinearity analysis containing both types of values must be assessed with care. It is probably preferable to convert non-numeric variables to numeric using target encoding rather before a multicollinearity analysis.
}
\examples{

#loading example data
data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

#computing Cramer's V for two categorical predictors
v <- cramer_v(
  x = vi$soil_type,
  y = vi$koppen_zone
  )

v

}
\references{
\itemize{
\item Cramér, H. (1946). Mathematical Methods of Statistics. Princeton: Princeton University Press, page 282 (Chapter 21. The two-dimensional case). ISBN 0-691-08004-6
}
}
\author{
Blas M. Benito
}
