% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{f_rf_auc_unbalanced}
\alias{f_rf_auc_unbalanced}
\title{AUC of Random Forest model of an unbalanced binary response}
\usage{
f_rf_auc_unbalanced(x, y, df)
}
\arguments{
\item{x}{(required, character string) name of the predictor variable.}

\item{y}{(required, character string) name of the binary response variable}

\item{df}{(required, data frame) data frame with the columns 'x' and 'y'.}
}
\value{
Area Under the Curve
}
\description{
Computes a univariate random forest model with weighted cases via \verb{\link[ranger]\{ranger\}} and returns the Area Under the Curve on the out-of-bag data.
}
\examples{

data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

#this example requires "ranger" installed in the system
if(requireNamespace(package = "ranger", quietly = TRUE)){

  f_rf_auc_unbalanced(
    x = "growing_season_length", #predictor
    y = "vi_binary",               #response
    df = vi
  )

}

}
