% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distributions.R
\name{lognormal_to_normal}
\alias{lognormal_to_normal}
\title{Convert lognormal parameters to normal parameters}
\usage{
lognormal_to_normal(meanlog, sdlog)
}
\arguments{
\item{meanlog}{Mean log.}

\item{sdlog}{Standard deviation log.}
}
\value{
A list.
}
\description{
Given a set of parameters describing a lognormal distribution, return
the parameters of the underlying normal distribution.
}
\examples{
lognormal_to_normal(meanlog=1, sdlog=3)
}
\seealso{
Other distribution fitting functions: \code{\link{combine_lognorm_trunc}},
  \code{\link{combine_lognorm}},
  \code{\link{combine_norm}},
  \code{\link{fit_capabilities_geomean}},
  \code{\link{fit_capabilities}},
  \code{\link{fit_lognorm_trunc}},
  \code{\link{fit_lognorm}}, \code{\link{fit_norm_trunc}},
  \code{\link{fit_pois}},
  \code{\link{fit_scenarios_geomean}},
  \code{\link{fit_scenarios}},
  \code{\link{fit_threat_communities}},
  \code{\link{generate_cost_function}},
  \code{\link{normal_to_lognormal}}
}
\concept{distribution fitting functions}
