% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priority_queue.R
\name{priority_queue}
\alias{priority_queue}
\title{Priority Queue}
\usage{
priority_queue(items = NULL, priorities = rep(0, length(items)))
}
\arguments{
\item{items}{a list of items}

\item{priorities}{a vector of interger valued priorities}
}
\description{
\code{priority_queue} creates a priority queue (a.k.a heap).
}
\details{
Following methods are exposed:
\preformatted{
.$push(item, priority = 0)
.$pop()
.$clear()
.$size()
.$as_list()
.$print()
}
\itemize{
\item \code{item}: any R object
\item \code{priority}: a real number, item with larger priority pops first
}
}
\examples{
q <- priority_queue()
q$push("not_urgent")
q$push("urgent", priority = 2)
q$push("not_as_urgent", priority = 1)
q$pop()  # urgent
q$pop()  # not_as_urgent
q$pop()  # not_urgent

q <- priority_queue(list("not_urgent", "urgent"), c(0, 2))
q$push("not_as_urgent", 1)$push("not_urgent2")
}
