% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.r
\name{flatten_coi5p}
\alias{flatten_coi5p}
\title{Flatten a list of coi5p output objects into a dataframe.}
\usage{
flatten_coi5p(x, keep_cols = "all")
}
\arguments{
\item{x}{A list of coi5p objects.}

\item{keep_cols}{The name of a coi5p object component, or a vector of components that should be turned into
dataframe columns. Available components are: name, raw, framed, aaSeq, aaScore, indel_likely, stop_codons.}
}
\value{
A dataframe with the coi5p object information flattened into columns.
}
\description{
This helper function is designed to act upon a list of coi5p objects and extract the object components
that the user requires.
}
\examples{
#create a list of coi5p objects
coi_output = lapply(example_barcode_data$sequence, function(x){
    coi5p_pipe(x)
  })
#flatten the list into a dataframe
coi_df = flatten_coi5p(coi_output)
#extract only a single column
coi_framed = flatten_coi5p(coi_output, keep_cols = "framed")
#or subset multiple columns
coi_framed = flatten_coi5p(coi_output, keep_cols = c("framed", "aaSeq"))
}
\seealso{
\code{\link{coi5p_pipe}}
}
