% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-quotes.R
\name{df.quotes.scm.edge}
\alias{df.quotes.scm.edge}
\title{Extract the quotes of a project linked to selected relationships}
\usage{
df.quotes.scm.edge(project, units, selected.edge)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{units}{A string vector giving the names of the units (i.e. classes linked to documents) that will be include in the SCM. It is a second type of filter.}

\item{selected.edge}{A vector of character value(s), the names of one or many relationship(s) of the map}
}
\value{
A data frame of relationships and quotes
}
\description{
Extract the quotes of a project linked to selected relationships
}
\details{
Extract the quotes of a project linked to selected relationships. Units is a mandatory parameter as this function was initially developped for given the quotes linked to significantly different relationships between groups of documents (i.e.  units).
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

df.quotes.scm.edge(my.project, "Belgium", "1~2")
}
