\name{batch.read}
\alias{batch.read}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
batch read different file data based on the order 1,2,3,4,5,6... in a folder
}
\description{
batch version of read.data() function, can read all the files in a folder
}
\usage{
batch.read(path, index = NULL, spnum = 2, islandnum = 10)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{path}{
a vector recording all the files in a folder, which can be generated by convert.filenames() function
}
  \item{index}{
local fielname/path for recording all the parameter combination index matrix generated from make.parcomb() function
}
  \item{spnum}{
species number in the model, default is 2
}
  \item{islandnum}{
patch number in the model,default is 10
}
}
\details{
return a list of data, each list member represents a model output
}

\references{
Chen YH (2012) coexist: an R package for performing species coexistence modeling and analysis under asymmetric dispersal and fluctuating source-sink dynamics.
http://code.google.com/p/coexist.
}
\author{
Youhua Chen <yhchen@zoology.ubc.ca>
}

\seealso{
\code{\link{read.data}}, 
\code{\link{read.patchdata}},
\code{\link{make.parcomb}}
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (path = pathvector, index = NULL, spnum = 2, islandnum = 10) 
{
    num <- length(path)
    outlist <- list()
    length(outlist) <- num
    if (length(index) == 0) {
        for (i in 1:num) {
            outlist[[i]] <- read.patchdata(path = path[i], spnum = spnum, 
                islandnum = islandnum)
        }
    }
    if (length(index) != 0) {
        for (i in 1:num) {
            outlist[[i]] <- read.data(path = path[i], index = index, 
                spnum = spnum, islandnum = islandnum)
        }
    }
    return(outlist)
  }
}
