% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCoef.r
\name{extract.coef.glm}
\alias{extract.coef.glm}
\title{extract.coef.glm}
\usage{
\method{extract.coef}{glm}(model, ...)
}
\arguments{
\item{model}{Model object to extract information from.}

\item{...}{Further arguments}
}
\value{
A \code{\link{data.frame}} containing the coefficient, the standard error and the variable name.
}
\description{
Extract Coefficient Information from glm Models
}
\details{
Gets the coefficient values and standard errors, and variable names from a glm model.
}
\examples{
\dontrun{
require(ggplot2)
data(diamonds)
library(coefplot)
mod2 <- glm(price > 10000 ~ carat + cut + x, data=diamonds, family=binomial(link="logit"))
extract.coef(mod2)
}

}
\author{
Jared P. Lander
}
