% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_structure.R
\name{community_structure}
\alias{community_structure}
\title{Community Structure}
\usage{
community_structure(df, time.var = NULL, abundance.var,
  replicate.var = NULL, metric = c("Evar", "SimpsonEvenness", "EQ"))
}
\arguments{
\item{df}{A data frame containing species and abundance columns and optional
columns of time and/or replicate.}

\item{time.var}{The name of the optional time column}

\item{abundance.var}{The name of the abundance column}

\item{replicate.var}{The name of the optional replicate column. If specified,
replicate must be unique within the dataset and cannot be nested within
treatments or blocks.}

\item{metric}{The measure of evenness to return:
\itemize{
 \item{"Evar": }{The default measure, calculates evenness as Evar from Smith and
 Wilson 1996}
 \item{"SimpsonEvenness": }{Calculates Simpson's evenness}
 \item{"EQ": }{Calculates evenness as EQ from Smith and Wilson 1996}
}}
}
\value{
The community_structure function returns a data frame with the
  following attributes:
\itemize{
 \item{time.var: }{A column that has the same name and type as the time.var
 column, if time.var is specified.}
 \item{replicate.var: }{A column that has same name and type as the
 replicate.var column, if specified.}
 \item{richness: }{A numeric column of species richness}
 \item{Evar: }{A numeric column of Evar if evenness = "Evar"}
 \item{EQ: }{A numeric column of EQ if evenness = "EQ"}
 \item{SimpsonEvenness: }{A numeric column of Simpson's evenness if evenness =
 "SimpsonEveness"}
}
}
\description{
Calculates species richness and evenness of a community.
  Evenness may be calculated as Simpson's (1/D/S), EQ, or Evar, but only one
  metric of evenness can be calculated at a time and must be specified.
}
\examples{
data(pplots)
#Example with both time and replicates
df <- subset(pplots, plot == 25 | plot == 6)
community_structure(df, 
                    time.var="year", 
                    replicate.var = "plot", 
                    abundance.var = "relative_cover") # for Evar evenness measure

df <- subset(pplots, plot == 25 | plot == 6)
community_structure(df,
                    time.var="year", 
                    replicate.var = "plot", 
                    abundance.var = "relative_cover", 
                    metric = "SimpsonEvenness") # for Simpson's evenness measure

#Example with no replicates
df <- subset(pplots, plot == 25)
community_structure(df, 
                    time.var="year", 
                    abundance.var = "relative_cover",
                    metric = "EQ") # for EQ evenness measure

#Example with only a single time point and no replicates
df <- subset(pplots, plot == 25 & year == 2002)
community_structure(df, 
                    abundance.var = "relative_cover") # for Evar evenness measure
}
\references{
Smith, B. and Wilson, J. B. 1996. A consumer's guide to evenness
  indices. Oikos 76: 70-82.
}
