% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codalm_em.R
\name{codalm}
\alias{codalm}
\title{Transformation-free Linear Regression for Compositional Outcomes and Predictors}
\usage{
codalm(y, x, accelerate = TRUE)
}
\arguments{
\item{y}{A matrix of compositional outcomes. Each row is an observation, and must sum to 1.
If any rows do not sum to 1, they will be renormalized}

\item{x}{A matrix of compositional predictors. Each row is an observation, and must sum to 1.
If any rows do not sum to 1, they will be renormalized}

\item{accelerate}{A logical variable, indicating whether or not to use the
Squarem algorithm for acceleration of the EM algorithm. Default is TRUE.}
}
\value{
A \eqn{D_s} x \eqn{D_r} compositional coefficient matrix, where
\eqn{D_s} and \eqn{D_r}  are the dimensions of the compositional predictor
and outcome, respectively
}
\description{
Implements the expectation-maximization (EM) algorithm as described
in Fiksel et al. (2020) for transformation-free linear regression for
compositional outcomes and predictors.
}
\examples{
data("educFM", package = 'robCompositions')
father <- as.matrix(educFM[,2:4])
y <- father / rowSums(father)
mother <- as.matrix(educFM[,5:7] )
x <- mother/rowSums(mother)
codalm(y, x)
}
\references{
\url{https://onlinelibrary.wiley.com/doi/full/10.1111/biom.13465}
}
