% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/common_tools.R
\name{data_collections2ggdf}
\alias{data_collections2ggdf}
\title{Catenate a set of data collections (lists of data.frames) into a single molted data.frame.}
\usage{
data_collections2ggdf(..., id.vars = NULL)
}
\arguments{
\item{...}{Several lists of data.frames to catenate}

\item{id.vars}{[1,m] string, ID variables for reshape::melt}
}
\value{
A data.frame with elements of ... melted and catenated vertically into a single data.frame.

Extra columns created:
\item{ds:}{dataset id within data collection}
\item{dc:}{data collection id}
}
\description{
Can be used e.g. to prepare data for plotting with ggplot().
}
\examples{
df_lst <- list(df1 = iris[,2:3], df2 = iris[2:3])
data_collections2ggdf(dc1 = df_lst, dc2 = df_lst)
}

