\name{bal.tab.mimids}
\alias{bal.tab.mimids}
\alias{bal.tab.wimids}
\title{
Balance Statistics for \code{MatchThem} Objects
}
\description{
Generates balance statistics for \code{mimids} and \code{wimids} objects from \pkg{MatchThem}.
}
\usage{
\method{bal.tab}{mimids}(x, 
    stats,
    int = FALSE, 
    poly = 1, 
    distance = NULL, 
    addl = NULL, 
    data = NULL, 
    continuous,  
    binary, 
    s.d.denom, 
    thresholds = NULL,
    weights = NULL,
    cluster = NULL, 
    abs = FALSE,
    subset = NULL,
    quick = TRUE, 
    ...)

\method{bal.tab}{wimids}(x, 
    stats,
    int = FALSE, 
    poly = 1, 
    distance = NULL, 
    addl = NULL, 
    data = NULL, 
    continuous,  
    binary, 
    s.d.denom, 
    thresholds = NULL,
    weights = NULL,
    cluster = NULL, 
    pairwise = TRUE, 
    abs = FALSE,
    subset = NULL,
    quick = TRUE, 
    ...)
}

\arguments{
  \item{x}{
a \code{mimids} or \code{wimids} object; the output of a call to \code{matchthem()} or \code{weightthem()} from the \pkg{MatchThem} package.
}
  \item{stats}{
\code{character}; which statistic(s) should be reported. See \code{\link[=balance.stats]{stats}} for allowable options. For binary and multi-category treatments, "mean.diffs" (i.e., mean differences) is the default. For continuous treatments, "correlations" (i.e., treatment-covariate Pearson correlations) is the default. Multiple options are allowed.
}
  \item{int}{
\code{logical} or \code{numeric}; whether or not to include 2-way interactions of covariates included in \code{covs} and in \code{addl}. If \code{numeric}, will be passed to \code{poly} as well. In older versions of \pkg{cobalt}, setting \code{int = TRUE} displayed squares of covariates; to replicate this behavior, set \code{int = 2}.
}
  \item{poly}{
\code{numeric}; the highest polynomial of each continuous covariate to display. For example, if 2, squares of each continuous covariate will be displayed (in addition to the covariate itself); if 3, squares and cubes of each continuous covariate will be displayed, etc. If 1, the default, only the base covariate will be displayed. If \code{int} is numeric, \code{poly} will take on the value of \code{int}.
}
  \item{distance}{
an optional formula or data frame containing distance values (e.g., propensity scores) or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look in the argument to \code{data}, if specified. Note that the distance measure generated by \code{matchthem()} or \code{weightthem()} is automatically included and named "distance" or "prop.score", respectively.
}
  \item{addl}{
an optional formula or data frame containing additional covariates for which to present balance or a character vector containing their names. If a formula or variable names are specified, \code{bal.tab()} will look first in the argument to \code{data}, if specified, and next in the \code{mimids} or \code{wimids} object.
}
  \item{data}{
an optional data frame or \code{mids} object containing variables that might be named in arguments to \code{distance}, \code{addl}, and \code{cluster}. See Examples.
}
  \item{continuous}{
whether mean differences for continuous variables should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"std"}. Abbreviations allowed. This option can be set globally using \code{\link{set.cobalt.options}}.
}
  \item{binary}{
whether mean differences for binary variables (i.e., difference in proportion) should be standardized (\code{"std"}) or raw (\code{"raw"}). Default \code{"raw"}. Abbreviations allowed. This option can be set globally using \code{\link{set.cobalt.options}}.
}
  \item{s.d.denom}{
\code{character}; how the denominator for standardized mean differences should be calculated, if requested. See \code{\link{col_w_smd}} for allowable options. The defaults depend on the options specified in the original function calls; see \code{\link{bal.tab.matchit}} and \code{\link{bal.tab.weightit}} for details on the defaults. Abbreviations allowed.
}
  \item{thresholds}{
a named vector of balance thresholds, where the name corresponds to the statistic (i.e., in \code{stats}) that the threshold applies to. For example, to request thresholds on mean differences and variance ratios, one can set \code{thresholds = c(m = .05, v = 2)}. Requesting a threshold automatically requests the display of that statistic. See Details.
}
  \item{weights}{
a named list containing additional weights on which to assess balance. Each entry can be a vector of weights, the name of a variable in \code{data} that contains weights, or an object with a \code{\link{get.w}} method.
}
  \item{cluster}{
either a vector containing cluster membership for each unit or a string containing the name of the cluster membership variable in \code{data} or the \code{mimids} or \code{wimids} object. See \code{\link[=class-bal.tab.cluster]{bal.tab.cluster}} for details.
}
  \item{pairwise}{
whether balance should be computed for pairs of treatments or for each treatment against all others combined. See \code{\link[=class-bal.tab.multi]{bal.tab.multi}} for details. 
}
  \item{abs}{
\code{logical}; whether displayed balance statistics should be in absolute value or not. 
}
  \item{subset}{
a \code{logical} or \code{numeric} vector denoting whether each observation should be included or which observations should be included. If \code{logical}, it should be the same length as the variables in the original (unimputed) dataset or the call to \code{matchthem()} or \code{weightthem()} (i.e., one for each individual or one for each individual for each imputation). \code{NA}s will be treated as \code{FALSE}. This can be used as an alternative to \code{cluster} to examine balance on subsets of the data.
}
  \item{quick}{
\code{logical}; if \code{TRUE}, will not compute any values that will not be displayed. Set to \code{FALSE} if computed values not displayed will be used later.
}
  \item{...}{
further arguments to control display of output. See \link[=options-display]{display options} for details.
}
}
\details{
\code{bal.tab.mimids()} and \code{bal.tab.wimids()} generate a list of balance summaries for the \code{mimids} or \code{wimids} object given.

The \code{threshold} argument controls whether extra columns should be inserted into the Balance table describing whether the balance statistics in question exceeded or were within the threshold. Including these thresholds also creates summary tables tallying the number of variables that exceeded and were within the threshold and displaying the variables with the greatest imbalance on that balance measure.

}
\value{
If clusters are not specified, an object of class \code{"bal.tab.imp"} containing balance summaries for each imputation and a summary of balance across imputations. See \code{\link[=class-bal.tab.imp]{bal.tab.imp}} for details.

If clusters are specified, an object of class \code{"bal.tab.imp.cluster"} containing summaries between and across all clusters and imputations.
}

\author{
Noah Greifer 
}

\seealso{
\code{\link{bal.tab}} for details of calculations.
}
\examples{\dontshow{if (all(sapply(c("mice", "MatchThem"), requireNamespace, quietly = TRUE))) \{}
library(mice)
library(MatchThem)

data("lalonde_mis", package = "cobalt")

#Imputing the missing data
imp <- mice(lalonde_mis, m = 5)

#Matching using within-imputation propensity scores
mt.out1 <- matchthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "within")
bal.tab(mt.out1)

#Matching using across-imputation average propensity scores
mt.out2 <- matchthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "across")
                       
bal.tab(mt.out2)

#Weighting using within-imputation propensity scores
wt.out <- weightthem(treat ~ age + educ + race + 
                       married + nodegree + re74 + re75, 
                       data = imp, approach = "within",
                       estimand = "ATT")
                       
bal.tab(wt.out)
\dontshow{\}}}
\keyword{tables}