% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_region_plot.R
\name{render_region_plot}
\alias{render_region_plot}
\title{Function to create a plot of a selected country.}
\usage{
render_region_plot(
  infile,
  outfile = NULL,
  fileExtension = ".png",
  visualizeVariables,
  visualizeDataMax,
  lon_bounds,
  lat_bounds,
  lon_loc_vec,
  lat_loc_vec,
  name_loc_vec,
  division,
  selectedRegion,
  region_data,
  timestep,
  num_tick,
  num_rmin,
  num_rmax,
  location,
  text1,
  text2,
  text3,
  PAL,
  palettes,
  num_brk,
  reverse,
  textsize,
  bordercolor,
  plot_grid,
  grid_col,
  image_def,
  ihsf
)
}
\arguments{
\item{infile}{The nc file to be visualized.}

\item{outfile}{Name of the outfile (NULL or character). Should match the fileExtension.
If NULL is passed a file is created in the R session temporary directory.}

\item{fileExtension}{The file extension of the image (character). Has to be one of the following: 'png', 'jpg', 'tif', 'kml', 'pdf'.}

\item{visualizeVariables}{A data frame containing all meta data for the plotting process (data.frame).}

\item{visualizeDataMax}{Maximal data for computing breaks.}

\item{lon_bounds}{Array containing two values for longitude min and max (numeric).}

\item{lat_bounds}{Array containing two values for latitude min and max (numeric).}

\item{lon_loc_vec}{All longitude entries for points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{lat_loc_vec}{All latitude entries for points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{name_loc_vec}{Names for the points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{division}{Division to contain region (either 'COUNTRY' or something coherent to region_data).}

\item{selectedRegion}{The region to be cropped according to division. If \code{division == "COUNTRY"}, the country's \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{3-character ISO code} should be used. Otherwise it has to fit to the passed region data.}

\item{region_data}{If Division is not 'COUNTRY' then region_data has to contain spatial data of the given division.}

\item{timestep}{Timestep to visualize at (character).}

\item{num_tick}{Number of ticks (numeric).}

\item{num_rmin}{Color scale range minimum (numeric).}

\item{num_rmax}{Color scale range maximium (numeric).}

\item{location}{Whether points specified by (lat_loc_vec, lon_loc_vec, name_loc_vec) should be added to the map (logical).}

\item{text1}{Title text (character).}

\item{text2}{Text to be passed to graphics::mtext (character).}

\item{text3}{Text to be added to the legend (character).}

\item{PAL}{Color palette.}

\item{palettes}{Color palettes to be used.}

\item{num_brk}{Number of breaks (numeric).}

\item{reverse}{Whether to revert the color palette (logical).}

\item{textsize}{Textsize to be used (cex).}

\item{bordercolor}{Color used for borders.}

\item{plot_grid}{Whether to plot a grid using color grid_col (logical).}

\item{grid_col}{Color used for the grid.}

\item{image_def}{Default size (positive numeric).}

\item{ihsf}{Image height scaling factor (positive numeric).}
}
\description{
This function generates a plot of within a certain region (e.g. a country).
}
\examples{
library(ncdf4)

## create some (non-realistic) example data
lon <- seq(-7.5, 7.5, 0.5)
lat <- seq(0, 15, 0.5)
time <- seq(as.Date("2000-01-01"), as.Date("2000-12-31"), "month")
origin <- as.Date("1983-01-01 00:00:00")
time <- as.numeric(difftime(time, origin, units = "hour"))
data <- array(1:31*31*12, dim = c(31, 31, 12))

x <- ncdim_def(name = "lon", units = "degrees_east", vals = lon)
y <- ncdim_def(name = "lat", units = "degrees_north", vals = lat)
t <- ncdim_def(name = "time", units = "hours since 1983-01-01 00:00:00",
               vals = time, unlim = TRUE)
var1 <- ncvar_def("VAR", "EX UNIT", list(x, y, t), -1, prec = "short")
vars <- list(var1)
ncfile <- tempfile(fileext = ".nc")
ncnew <- nc_create(ncfile, vars)
ncvar_put(ncnew, var1, data)
ncatt_put(ncnew, "lon", "standard_name", "longitude", prec = "text")
ncatt_put(ncnew, "lat", "standard_name", "latitude", prec = "text")
nc_close(ncnew)

visualizeVariables <- list(
 plot_dim = 2,
 date.time = seq(as.Date("2000-01-01"), as.Date("2010-12-31"), "month"),
 data = data,
 min_lon = -7.5,
 max_lon = 7.5,
 min_lat = 0,
 max_lat = 15,
 lon = lon,
 lat = lat,
 vn = "VAR",
 varname = "Example var name",
 copyrightText = "Example Copyright",
 unit = "example unit"
)

palettes <- data.frame(
  type = "qual",
  h1 = 0,
  h2 = 360,
  c1 = 35,
  c2 = NA,
  l1 = 85,
  l2 = NA,
  p1 = NA,
  p2 = NA,
  cmax = NA,
  fixup = 1
)

rownames(palettes) = "Pastel 1"

render_region_plot(
 infile = ncfile,
 visualizeVariables = visualizeVariables,
 visualizeDataMax = 31*31,
 lon_bounds = c(-7.5, 7.5),
 lat_bounds = c(0, 15),
 division = "COUNTRY",
 selectedRegion = "GHA",
 timestep = as.Date("2000-01-01"),
 num_tick = 10,
 num_rmin = 0,
 num_rmax = 31*31*12,
 num_brk = 10,
 location = FALSE,
 text1 = "Text 1",
 text2 = "Text 2",
 text3 = "Text 3",
 textsize = 1.2,
 bordercolor = "gray20",
 PAL = "Pastel 1",
 palettes = palettes,
 reverse = FALSE,
 plot_grid = TRUE,
 grid_col = "cornsilk2",
 image_def = 800,
 ihsf = 0.1
)

}
