% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mondaymean.R
\name{mondaymean}
\alias{mondaymean}
\title{Determine mean monthly daily variations}
\usage{
mondaymean(
  var,
  infile,
  outfile,
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE,
  nc = NULL
)
}
\arguments{
\item{var}{Name of NetCDF variable (character).}

\item{infile}{Filename of input NetCDF file. This may include the directory
(character).}

\item{outfile}{Filename of output NetCDF file. This may include the directory
(character).}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?}

\item{verbose}{logical; if TRUE, progress messages are shown}

\item{nc}{Alternatively to \code{infile} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\value{
A NetCDF file including a time series of mean monthly daily variations is written.
}
\description{
The function determines mean monthly daily variations values from data of a single CM SAF
NetCDF input file. This function is applicable to 3-dimensional NetCDF data.
}
\examples{
\donttest{
## Create an example NetCDF file with a similar structure as used by CM
## SAF. The file is created with the ncdf4 package.  Alternatively
## example data can be freely downloaded here: <https://wui.cmsaf.eu/>

library(ncdf4)

lon <- seq(5, 8, 0.5)
lat <- seq(45, 48, 0.5)
time <- seq(ISOdate(2000, 3, 1), ISOdate(2000, 5, 31), "hours")
origin <- format("1983-01-01 00:00:00")
time <- as.numeric(difftime(time, origin, units = "hour"))
data <- array(250:272, dim = c(7, 7, 2185))

x <- ncdim_def(name = "lon", units = "degrees_east", vals = lon)
y <- ncdim_def(name = "lat", units = "degrees_north", vals = lat)
t <- ncdim_def(name = "time", units = "hours since 1983-01-01 00:00:00",
             vals = time, unlim = TRUE)
var1 <- ncvar_def("SIS", "W m-2", list(x, y, t), -999, prec = "short",
                longname = "Surface Incoming Shortwave Radiation")
vars <- list(var1)
ncnew <- nc_create(file.path(tempdir(), "CMSAF_example_file.nc"), vars)
ncvar_put(ncnew, var1, data)
ncatt_put(ncnew, "lon", "standard_name", "longitude", prec = "text")
ncatt_put(ncnew, "lat", "standard_name", "latitude", prec = "text")
ncatt_put(ncnew, "SIS", "standard_name", "SIS_standard", prec = "text")
nc_close(ncnew)

## Determine the mean monthly daily variations of the example CM SAF NetCDF file and
## write the output to a new file.
mondaymean(var = "SIS", infile = file.path(tempdir(), "CMSAF_example_file.nc"), 
 outfile = file.path(tempdir(), "CMSAF_example_file_mondaymean.nc"))

unlink(c(file.path(tempdir(),"CMSAF_example_file.nc"), 
 file.path(tempdir(),"CMSAF_example_file_mondaymean.nc")))
 }
}
\seealso{
Other monthly statistics: 
\code{\link{mon.anomaly}()},
\code{\link{mon_num_above}()},
\code{\link{mon_num_below}()},
\code{\link{mon_num_equal}()},
\code{\link{monavg}()},
\code{\link{monmax}()},
\code{\link{monmean}()},
\code{\link{monmin}()},
\code{\link{monpctl}()},
\code{\link{monsd}()},
\code{\link{monsum}()},
\code{\link{monvar}()},
\code{\link{multimonmean}()},
\code{\link{multimonsum}()},
\code{\link{ymonmax}()},
\code{\link{ymonmean}()},
\code{\link{ymonmin}()},
\code{\link{ymonsd}()},
\code{\link{ymonsum}()}
}
\concept{monthly statistics}
