% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ccf4.R
\name{get_ccf4}
\alias{get_ccf4}
\title{Function to calculate the cross-correlation between two sequences}
\usage{
get_ccf4(x, y, min.overlap = round(0.1 * max(length(x), length(y))))
}
\arguments{
\item{x}{numeric sequence of values}

\item{y}{numeric sequence of values}

\item{min.overlap}{integer, minimal number of values in the overlap between sequences x and y to calculate a correlation value. Set to 10 percent of the maximum length of either sequence (HH: this might be problematic for CMPS)}
}
\value{
list consisting of the lag where the maximum correlation is achieved, and the maximum correlation value.
}
\description{
This function is used for CMPS algorithm.
}
\examples{
data("bullets")
land2_3 <- bullets$sigs[bullets$bulletland == "2-3"][[1]]
land1_2 <- bullets$sigs[bullets$bulletland == "1-2"][[1]]
x <- land2_3$sig
y <- land1_2$sig

segments <- get_segs(x, len = 50)

ccr <- get_ccf4(y, segments$segs[[7]], 
                min.overlap = length(segments$segs[[7]]))
}
