% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtpwr.2mean.R
\name{crtpwr.2mean}
\alias{crtpwr.2mean}
\title{Power calculations for simple cluster randomized trials, continuous outcome}
\usage{
crtpwr.2mean(alpha = 0.05, power = 0.8, m = NA, n = NA, cv = 0,
  d = NA, icc = NA, varw = NA, method = c("taylor", "weighted"),
  tol = .Machine$double.eps^0.25)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{m}{The number of clusters per condition. It must be greater than 1.}

\item{n}{The mean of the cluster sizes, or a vector of cluster sizes for one arm.}

\item{cv}{The coefficient of variation of the cluster sizes. When \code{cv} = 0,
the clusters all have the same size.}

\item{d}{The difference in condition means.}

\item{icc}{The intraclass correlation.}

\item{varw}{The within-cluster variation.}

\item{method}{The method for calculating variance inflation due to unequal cluster
sizes. Either a method based on Taylor approximation of relative efficiency 
("taylor"), or weighting by cluster size ("weighted")}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed argument.
}
\description{
Compute the power of a simple cluster randomized trial with a continuous outcome,
or determine parameters to obtain a target power.
}
\details{
Exactly one of \code{alpha}, \code{power}, \code{m}, \code{n},
  \code{nsd}, \code{d}, \code{icc}, and \code{varw}  must be passed as \code{NA}.
  Note that \code{alpha}, \code{power}, and \code{nsd} have non-\code{NA}
  defaults, so if those are the parameters of interest they must be
  explicitly passed as \code{NA}.
  
If \code{n} is a vector the values, \code{m} and \code{cv} will be recalculated
   using the values in \code{n}. If \code{n} is a vector and \code{method} is
   "taylor", the exact relative efficiency will be calculated as described in
   van Breukelen et al (2007).
}
\section{Note}{

  'uniroot' is used to solve power equation for unknowns, so you may see
  errors from it, notably about inability to bracket the root when
  invalid arguments are given.
}

\examples{
# Find the number of clusters per condition needed for a trial with alpha = .05, 
# power = 0.8, 10 observations per cluster, no variation in cluster size, a difference 
# of 1 unit,  icc = 0.1 and   a variance of five units.
crtpwr.2mean(n=10 ,d=1, icc=.1, varw=5)
# 
# The result, showimg m of greater than 15, suggests 16 clusters per condition should be used.
}
\references{
Eldridge SM, Ukoumunne OC, Carlin JB. (2009) The Intra-Cluster Correlation
  Coefficient in Cluster Randomized Trials: A Review of Definitions. Int Stat Rev. 
  77: 378-394.

Eldridge SM, Ashby D, Kerry S. (2006) Sample size for cluster randomized
  trials: effect of coefficient of variation of cluster size and analysis method.
  Int J Epidemiol. 35(5):1292-300.

van Breukelen GJP, Candel MJJM, Berger MPF. (2007) Relative efficiency of
  unequal versus equal cluster sizes in cluster randomized and multicentre trials.
  Statist Med. 26:2589-2603.
}
\author{
Jonathan Moyer (\email{jon.moyer@gmail.com})
}
