\name{dkplot}
\alias{dkplot}
\title{
Generate a delta-K plot from area under the curve (AUC) values across multiple cluster numbers.
}
\description{
This function uses the \code{\link{lattice}} function \code{\link{xyplot}} to generate an delta-K plot from a valid \code{"dk"} class object (see \code{\link{dk-class}}).  
}
\usage{
dkplot(x)
}

\arguments{
	\item{x}{
		a valid "dk" class object (see \code{\link{dk-class}}), normally generated by the \code{\link{deltak}} function.
	}
}

\references{
Merged consensus clustering to assess and improve classification of microarray data. Simpson, T.I., Armstrong, J.D. and Jarman A.P.
(submitted).}

\author{
Dr. T. Ian Simpson
\email{ian.simpson@ed.ac.uk}
}

\seealso{
\code{\link{consmatrix-class}}
}
\examples{
#load up a test cluscomp result
data('testcmr');

#look at the result structure
summary(testcmr);

#reduce size for the example
testcmr <- testcmr[1:12];

#calculate all of the AUC values from the cluscomp result
acs <- aucs(testcmr);

#calculate all of the delta-K values
dks <- deltak(acs);

#plot the delta-K curve
dkplot(dks);
}