\name{aucplot}
\alias{aucplot}
\title{
Generate an area under the curve plot using lattice graphics
}
\description{
This function uses the \code{\link{lattice}} function \code{\link{xyplot}} to generate an AUC plot from a valid \code{"auc"} class object (see \code{\link{auc-class}}).
}
\usage{
aucplot(x)
}

\arguments{
	\item{x}{
		a valid "auc" class object (see \code{\link{auc-class}}), normally generated by the \code{\link{aucs}} function.
	}
}

\references{
Merged consensus clustering to assess and improve classification of microarray data. Simpson, T.I., Armstrong, J.D. and Jarman A.P.
(submitted).}

\author{
Dr. T. Ian Simpson
\email{ian.simpson@ed.ac.uk}
}

\seealso{
\code{\link{consmatrix-class}}
}
\examples{
#load up a test cluscomp result
data('testcmr');

#look at the result structure
summary(testcmr);

#reduce size for the example
testcmr <- testcmr[1:12];

#calculate all of the AUC values from the cluscomp result
acs <- aucs(testcmr);

#plot the AUC curve
aucplot(acs);
}