% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kprototypes.R
\name{summary.kproto}
\alias{summary.kproto}
\title{Summary method for kproto cluster result}
\usage{
\method{summary}{kproto}(object, data = NULL, pct.dig = 3, ...)
}
\arguments{
\item{object}{Object of class \code{kproto}.}

\item{data}{Optional data set to be analyzed. If \code{!(is.null(data))} clusters for \code{data} are assigned by 
\code{predict(object, data)}. If not specified the clusters of the original data ara analyzed. Only possible if \code{kproto} 
has been called using \code{keep.data = TRUE}.}

\item{pct.dig}{Number of digits for rounding percentages of factor variables.}

\item{\dots}{Further arguments to be passed to internal call of \code{summary()} for numeric variables.}
}
\value{
List where each element corresponds to one variable. Each row of any element corresponds to one cluster.
}
\description{
Investigation of variances to specify lambda for k prototypes clustering.
}
\details{
For numeric variables statistics are computed for each clusters using \code{summary()}. 
For categorical variables distribution percent are computed.
}
\examples{
# generate toy data with factors and numerics

n   <- 100
prb <- 0.9
muk <- 1.5 
clusid <- rep(1:4, each = n)

x1 <- sample(c("A","B"), 2*n, replace = TRUE, prob = c(prb, 1-prb))
x1 <- c(x1, sample(c("A","B"), 2*n, replace = TRUE, prob = c(1-prb, prb)))
x1 <- as.factor(x1)

x2 <- sample(c("A","B"), 2*n, replace = TRUE, prob = c(prb, 1-prb))
x2 <- c(x2, sample(c("A","B"), 2*n, replace = TRUE, prob = c(1-prb, prb)))
x2 <- as.factor(x2)

x3 <- c(rnorm(n, mean = -muk), rnorm(n, mean = muk), rnorm(n, mean = -muk), rnorm(n, mean = muk))
x4 <- c(rnorm(n, mean = -muk), rnorm(n, mean = muk), rnorm(n, mean = -muk), rnorm(n, mean = muk))

x <- data.frame(x1,x2,x3,x4)

res <- kproto(x, 4)
summary(res)

}
\author{
\email{gero.szepannek@web.de}
}

