% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions.R
\name{coverage}
\alias{coverage}
\title{Coverage}
\usage{
coverage(g, com)
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object).}

\item{com}{Community membership integer vector. Each element corresponds to a vertex
of the graph, and contains the index of the community it belongs to.}
}
\value{
Numeric value of the coverage of \code{g} and \code{com}.
}
\description{
Computes the coverage (fraction of internal edges with respect to the total
number of edges) of a graph and its communities
}
\examples{
data(karate, package="igraphdata")
coverage(karate, membership(cluster_louvain(karate)))
}
\seealso{
Other cluster scoring functions: 
\code{\link{FOMD}()},
\code{\link{average_degree}()},
\code{\link{average_odf}()},
\code{\link{conductance}()},
\code{\link{cut_ratio}()},
\code{\link{density_ratio}()},
\code{\link{edges_inside}()},
\code{\link{expansion}()},
\code{\link{internal_density}()},
\code{\link{max_odf}()},
\code{\link{normalized_cut}()},
\code{\link{scoring_functions}()},
\code{\link{weighted_clustering_coefficient}()},
\code{\link{weighted_transitivity}()}
}
\concept{cluster scoring functions}
