% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/significance_functions.R
\name{evaluate_significance}
\alias{evaluate_significance}
\title{Evaluates significance of cluster algorithm results on a graph}
\usage{
evaluate_significance(
  g,
  alg_list = list(Louvain = cluster_louvain, `label prop` = cluster_label_prop,
    walktrap = cluster_walktrap),
  no_clustering_coef = TRUE,
  ground_truth = FALSE,
  gt_clustering = NULL,
  w_max = NULL
)
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object)}

\item{alg_list}{List of clustering algorithms, which take an \code{igraph} graph as
input and return an object of the \code{communities} class.}

\item{no_clustering_coef}{Logical. If \code{TRUE}, skips the computation of the clustering
coefficient, which is the most computationally costly of the scoring functions.}

\item{ground_truth}{Logical. If set to \code{TRUE}, computes the scoring functions for 
a ground truth clustering, which has to be provided as \code{gt_clustering}}

\item{gt_clustering}{Vector of integers that correspond to labels of the ground truth clustering. 
Only used if \code{ground_truth} is set to \code{TRUE}.}

\item{w_max}{Numeric. Upper bound for edge weights. Should be generally left as default (\code{NULL}).}
}
\value{
A data frame with the values of scoring functions (see \code{\link[clustAnalytics]{scoring_functions}}) 
of the clusters obtained by
applying the clustering algorithms to the graph.
}
\description{
Given a graph and a list of clustering algorithms, computes several scoring
functions on the clusters found by each of the algorithms.
}
\examples{
data(karate, package="igraphdata")
evaluate_significance(karate)
}
