% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranksum-perm.R
\name{cluswilcox.test.ranksum.permutation}
\alias{cluswilcox.test.ranksum.permutation}
\title{Wilcoxon Rank Sum Test for Clustered Data using Permutation}
\usage{
\method{cluswilcox.test}{ranksum.permutation}(x, cluster, group, strats,
  alternative, mu, n.rep, DNAME = NULL, METHOD = NULL)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{cluster}{a numeric vector indicating the cluster ids of the scores.
If not specified, each score has its own id, i.e., there is no
cluster in the data.}

\item{group}{a numeric vector indicating group id.}

\item{strats}{a numeric vector indicatg the strats ids of
the scores. The default is that the data has no stratum.}

\item{alternative}{a character string specifying the
alternative hypothesis, must be one of "two.sided" (default),
 "greater" or "less". You can specify just the initial letter.}

\item{mu}{null value of the hypothesis}

\item{n.rep}{number of samples generated for permutation test.}

\item{DNAME}{a character string, inheritated from
\code{cluswilcox.test.model}, for result output.}

\item{METHOD}{a character string, inheritated from
\code{cluswilcox.test.model}, for result output.}
}
\value{
a list with the followin.csize components
\item{rstatistic}{Clustered Wilcoxon ranksum statistic.}
\item{p.value}{the p-value for the test}
\item{data.name}{a character string giving the names of the data.}
\item{method}{the name of the method}
\item{balance}{a logical, indicating if the data is balanced.}
}
\description{
This is the rank sum test for clustered data.
The cluster size can be either
identitical or variable. Effect of stratification on the test
is also adjusted for if in presence, permutation is used to
obtain p-value of the test..
}
\examples{
data(crd)
cluswilcox.test(z ~ group(group) + cluster(id), data = crd, permutation = TRUE)
data(crdStr)
cluswilcox.test(z ~ group(group) + cluster(id) + stratum(stratum),
data = crdStr, permutation = TRUE)

}
\author{
Yujing Jiang
}
\references{
Bernard Rosner, Robert J. Glynn, Mei-Ling Ting Lee(2003)
\emph{Incorporation of Clustering Effects for the Wilcoxon Rank
Sum Test: A Large-Sample Approach.} Biometrics, \bold{59}, 1089-1098.
}

