% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcloud-storage.R
\name{gs_data_dir}
\alias{gs_data_dir}
\title{Google storage bucket path that syncs to local storage when not
running on CloudML.}
\usage{
gs_data_dir(url, local_dir = "gs", force_sync = FALSE, echo = TRUE)
}
\arguments{
\item{url}{Google Storage bucket URL (e.g. \code{gs://<your-bucket>}).}

\item{local_dir}{Local directory to synchonize Google Storage bucket(s) to.}

\item{force_sync}{Force local synchonization even if the data
directory already exists.}

\item{echo}{Echo command output to console.}
}
\value{
Path to contents of data directory.
}
\description{
Refer to data within a Google Storage bucket. When running on CloudML
the bucket will be read from directly. Otherwise, the bucket will be
automatically synchronized to a local directory.
}
\details{
This function is suitable for use in TensorFlow APIs that accept
gs:// URLs (e.g. TensorFlow datasets). However, many package functions
accept only local filesystem paths as input (rather than
gs:// URLs). For these cases you can the \code{\link[=gs_data_dir_local]{gs_data_dir_local()}} function,
which will always synchronize gs:// buckets to the local filesystem and
provide a local path interface to their contents.
}
\seealso{
\code{\link[=gs_data_dir_local]{gs_data_dir_local()}}
}
