% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{job_list}
\alias{job_list}
\title{List all jobs}
\usage{
job_list(filter = NULL, limit = NULL, page_size = NULL, sort_by = NULL,
  uri = FALSE)
}
\arguments{
\item{filter}{Filter the set of jobs to be returned.}

\item{limit}{The maximum number of resources to list. By default,
all jobs will be listed.}

\item{page_size}{Some services group resource list output into pages.
This flag specifies the maximum number of resources per
page. The default is determined by the service if it
supports paging, otherwise it is unlimited (no paging).}

\item{sort_by}{A comma-separated list of resource field key names to
sort by. The default order is ascending. Prefix a field
with \code{~} for descending order on that field.}

\item{uri}{Print a list of resource URIs instead of the default
output.}
}
\description{
List existing Google Cloud ML jobs.
}
\seealso{
Other job management functions: \code{\link{job_cancel}},
  \code{\link{job_collect}}, \code{\link{job_status}},
  \code{\link{job_stream_logs}}, \code{\link{job_trials}}
}
