/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunJobFlowRequest
extends AmazonWebServiceRequest {
    private String name;
    private String logUri;
    private String additionalInfo;
    private String amiVersion;
    private JobFlowInstancesConfig instances;
    private List<StepConfig> steps;
    private List<BootstrapActionConfig> bootstrapActions;
    private List<String> supportedProducts;

    public RunJobFlowRequest() {
    }

    public RunJobFlowRequest(String name, JobFlowInstancesConfig instances) {
        this.name = name;
        this.instances = instances;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RunJobFlowRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getLogUri() {
        return this.logUri;
    }

    public void setLogUri(String logUri) {
        this.logUri = logUri;
    }

    public RunJobFlowRequest withLogUri(String logUri) {
        this.logUri = logUri;
        return this;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public RunJobFlowRequest withAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public String getAmiVersion() {
        return this.amiVersion;
    }

    public void setAmiVersion(String amiVersion) {
        this.amiVersion = amiVersion;
    }

    public RunJobFlowRequest withAmiVersion(String amiVersion) {
        this.amiVersion = amiVersion;
        return this;
    }

    public JobFlowInstancesConfig getInstances() {
        return this.instances;
    }

    public void setInstances(JobFlowInstancesConfig instances) {
        this.instances = instances;
    }

    public RunJobFlowRequest withInstances(JobFlowInstancesConfig instances) {
        this.instances = instances;
        return this;
    }

    public List<StepConfig> getSteps() {
        if (this.steps == null) {
            this.steps = new ArrayList<StepConfig>();
        }
        return this.steps;
    }

    public void setSteps(Collection<StepConfig> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        ArrayList<StepConfig> stepsCopy = new ArrayList<StepConfig>(steps.size());
        stepsCopy.addAll(steps);
        this.steps = stepsCopy;
    }

    public RunJobFlowRequest withSteps(StepConfig ... steps) {
        if (this.getSteps() == null) {
            this.setSteps(new ArrayList<StepConfig>(steps.length));
        }
        for (StepConfig value : steps) {
            this.getSteps().add(value);
        }
        return this;
    }

    public RunJobFlowRequest withSteps(Collection<StepConfig> steps) {
        if (steps == null) {
            this.steps = null;
        } else {
            ArrayList<StepConfig> stepsCopy = new ArrayList<StepConfig>(steps.size());
            stepsCopy.addAll(steps);
            this.steps = stepsCopy;
        }
        return this;
    }

    public List<BootstrapActionConfig> getBootstrapActions() {
        if (this.bootstrapActions == null) {
            this.bootstrapActions = new ArrayList<BootstrapActionConfig>();
        }
        return this.bootstrapActions;
    }

    public void setBootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
            return;
        }
        ArrayList<BootstrapActionConfig> bootstrapActionsCopy = new ArrayList<BootstrapActionConfig>(bootstrapActions.size());
        bootstrapActionsCopy.addAll(bootstrapActions);
        this.bootstrapActions = bootstrapActionsCopy;
    }

    public RunJobFlowRequest withBootstrapActions(BootstrapActionConfig ... bootstrapActions) {
        if (this.getBootstrapActions() == null) {
            this.setBootstrapActions(new ArrayList<BootstrapActionConfig>(bootstrapActions.length));
        }
        for (BootstrapActionConfig value : bootstrapActions) {
            this.getBootstrapActions().add(value);
        }
        return this;
    }

    public RunJobFlowRequest withBootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
        } else {
            ArrayList<BootstrapActionConfig> bootstrapActionsCopy = new ArrayList<BootstrapActionConfig>(bootstrapActions.size());
            bootstrapActionsCopy.addAll(bootstrapActions);
            this.bootstrapActions = bootstrapActionsCopy;
        }
        return this;
    }

    public List<String> getSupportedProducts() {
        if (this.supportedProducts == null) {
            this.supportedProducts = new ArrayList<String>();
        }
        return this.supportedProducts;
    }

    public void setSupportedProducts(Collection<String> supportedProducts) {
        if (supportedProducts == null) {
            this.supportedProducts = null;
            return;
        }
        ArrayList<String> supportedProductsCopy = new ArrayList<String>(supportedProducts.size());
        supportedProductsCopy.addAll(supportedProducts);
        this.supportedProducts = supportedProductsCopy;
    }

    public RunJobFlowRequest withSupportedProducts(String ... supportedProducts) {
        if (this.getSupportedProducts() == null) {
            this.setSupportedProducts(new ArrayList<String>(supportedProducts.length));
        }
        for (String value : supportedProducts) {
            this.getSupportedProducts().add(value);
        }
        return this;
    }

    public RunJobFlowRequest withSupportedProducts(Collection<String> supportedProducts) {
        if (supportedProducts == null) {
            this.supportedProducts = null;
        } else {
            ArrayList<String> supportedProductsCopy = new ArrayList<String>(supportedProducts.size());
            supportedProductsCopy.addAll(supportedProducts);
            this.supportedProducts = supportedProductsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("Name: " + this.name + ", ");
        }
        if (this.logUri != null) {
            sb.append("LogUri: " + this.logUri + ", ");
        }
        if (this.additionalInfo != null) {
            sb.append("AdditionalInfo: " + this.additionalInfo + ", ");
        }
        if (this.amiVersion != null) {
            sb.append("AmiVersion: " + this.amiVersion + ", ");
        }
        if (this.instances != null) {
            sb.append("Instances: " + this.instances + ", ");
        }
        if (this.steps != null) {
            sb.append("Steps: " + this.steps + ", ");
        }
        if (this.bootstrapActions != null) {
            sb.append("BootstrapActions: " + this.bootstrapActions + ", ");
        }
        if (this.supportedProducts != null) {
            sb.append("SupportedProducts: " + this.supportedProducts + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getLogUri() == null ? 0 : this.getLogUri().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.getAmiVersion() == null ? 0 : this.getAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : ((Object)this.getSteps()).hashCode());
        hashCode = 31 * hashCode + (this.getBootstrapActions() == null ? 0 : ((Object)this.getBootstrapActions()).hashCode());
        hashCode = 31 * hashCode + (this.getSupportedProducts() == null ? 0 : ((Object)this.getSupportedProducts()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunJobFlowRequest)) {
            return false;
        }
        RunJobFlowRequest other = (RunJobFlowRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getLogUri() == null ^ this.getLogUri() == null) {
            return false;
        }
        if (other.getLogUri() != null && !other.getLogUri().equals(this.getLogUri())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        if (other.getAdditionalInfo() != null && !other.getAdditionalInfo().equals(this.getAdditionalInfo())) {
            return false;
        }
        if (other.getAmiVersion() == null ^ this.getAmiVersion() == null) {
            return false;
        }
        if (other.getAmiVersion() != null && !other.getAmiVersion().equals(this.getAmiVersion())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !((Object)other.getSteps()).equals(this.getSteps())) {
            return false;
        }
        if (other.getBootstrapActions() == null ^ this.getBootstrapActions() == null) {
            return false;
        }
        if (other.getBootstrapActions() != null && !((Object)other.getBootstrapActions()).equals(this.getBootstrapActions())) {
            return false;
        }
        if (other.getSupportedProducts() == null ^ this.getSupportedProducts() == null) {
            return false;
        }
        return other.getSupportedProducts() == null || ((Object)other.getSupportedProducts()).equals(this.getSupportedProducts());
    }
}

