/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodb.model.PutItemRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutItemRequestMarshaller
implements Marshaller<Request<PutItemRequest>, PutItemRequest> {
    @Override
    public Request<PutItemRequest> marshall(PutItemRequest putItemRequest) {
        if (putItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutItemRequest> request = new DefaultRequest<PutItemRequest>(putItemRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.PutItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(putItemRequest.getTableName());
            }
            if (putItemRequest.getItem() != null) {
                int itemEntryIndex = 1;
                jsonWriter.key("Item").object();
                for (Map.Entry<String, Object> entry : putItemRequest.getItem().entrySet()) {
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    if (((AttributeValue)entry.getValue()).getS() != null) {
                        jsonWriter.key("S").value(((AttributeValue)entry.getValue()).getS());
                    }
                    if (((AttributeValue)entry.getValue()).getN() != null) {
                        jsonWriter.key("N").value(((AttributeValue)entry.getValue()).getN());
                    }
                    if (entry.getValue() != null) {
                        List<String> sSList = ((AttributeValue)entry.getValue()).getSS();
                        int sSListIndex = 0;
                        if (sSList != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                if (sSListValue != null) {
                                    jsonWriter.value(sSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++sSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    if (entry.getValue() != null) {
                        List<String> nSList = ((AttributeValue)entry.getValue()).getNS();
                        int nSListIndex = 0;
                        if (nSList != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                if (nSListValue != null) {
                                    jsonWriter.value(nSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++nSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    jsonWriter.endObject();
                    ++itemEntryIndex;
                }
                jsonWriter.endObject();
            }
            if (putItemRequest.getExpected() != null) {
                int expectedEntryIndex = 1;
                jsonWriter.key("Expected").object();
                for (Map.Entry<String, Object> entry : putItemRequest.getExpected().entrySet()) {
                    AttributeValue attributeValueValue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    if (entry.getValue() != null && (attributeValueValue = ((ExpectedAttributeValue)entry.getValue()).getValue()) != null) {
                        jsonWriter.key("Value").object();
                        if (attributeValueValue.getS() != null) {
                            jsonWriter.key("S").value(attributeValueValue.getS());
                        }
                        if (attributeValueValue.getN() != null) {
                            jsonWriter.key("N").value(attributeValueValue.getN());
                        }
                        if (attributeValueValue != null) {
                            List<String> sSList = attributeValueValue.getSS();
                            int sSListIndex = 0;
                            if (sSList != null && sSList.size() > 0) {
                                jsonWriter.key("SS").array();
                                for (String sSListValue : sSList) {
                                    if (sSListValue != null) {
                                        jsonWriter.value(sSListValue);
                                    } else {
                                        jsonWriter.value(null);
                                    }
                                    ++sSListIndex;
                                }
                                jsonWriter.endArray();
                            }
                        }
                        if (attributeValueValue != null) {
                            List<String> nSList = attributeValueValue.getNS();
                            int nSListIndex = 0;
                            if (nSList != null && nSList.size() > 0) {
                                jsonWriter.key("NS").array();
                                for (String nSListValue : nSList) {
                                    if (nSListValue != null) {
                                        jsonWriter.value(nSListValue);
                                    } else {
                                        jsonWriter.value(null);
                                    }
                                    ++nSListIndex;
                                }
                                jsonWriter.endArray();
                            }
                        }
                        jsonWriter.endObject();
                    }
                    if (((ExpectedAttributeValue)entry.getValue()).isExists() != null) {
                        jsonWriter.key("Exists").value(((ExpectedAttributeValue)entry.getValue()).isExists());
                    }
                    jsonWriter.endObject();
                    ++expectedEntryIndex;
                }
                jsonWriter.endObject();
            }
            if (putItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value(putItemRequest.getReturnValues());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

