# cloudRmpi_windows_patch_1.R
#
# Windows patch for rreval 1.0, cloudRmpi 1.0

# Added to MessageNio.R in rreval
getJavaAppClassPath <- function(packageName,quoted=TRUE) {
  
  pkPath <- .find.package(packageName);
  cp <- paste(pkPath,"/jars/*",sep="");
  if ( .Platform$OS == "windows" )
    cp <- gsub("/","\\\\",cp);
  if ( quoted ) paste("\"",cp,"\"",sep="")
  else cp 
}
 
# Added to PPEClient.R in cloudRmpi
getClassPath <- function() {
  
  if ( .Platform$OS == "windows" ) cpSep <- ";"
  else cpSep <- ":";
  
  cp <- paste(getJavaAppClassPath("cloudRmpi",quoted=FALSE),
              getJavaAppClassPath("cloudRmpiJars",quoted=FALSE),
              sep=cpSep
              );
  paste("\"",cp,"\"",sep="")
}

ppe.getNetworkNames <- function() {
  
  nnS <- sendCmdToNetworkManager(cmdName="getNetworkNames");
  
  if ( is.null(nnS) || (nchar(trim(nnS)) < 1) ) { 
    stop(simpleError("No ompi-ppe networks were found."));
  }   
  else {
    nnms <- parseNetworkNames(x=nnS); #strsplit(x=nnS,split=" ");
    if ( length(nnms) > 0 ) return(unlist(nnms))
    else {
      stop(simpleError("No ompi-ppe networks were found."));
    }
  }
}

parseNetworkNames <- function(x) {
  user <- Sys.info()["user"];
  user.ns <- gsub(pattern=" ",replacement="#^",x=user);
  xns <- gsub(pattern=user,replacement=user.ns,x=x);
  z <- unlist(strsplit(x=xns,split=" "));  
  gsub(pattern=user.ns,replacement=user,x=z,fixed=TRUE)
}



cloudRmpiPatch <- function() {
  
  assignInNamespace(x="getJavaAppClassPath",
                    value=getJavaAppClassPath,
                    ns="rreval");
  
  assignInNamespace(x="getClassPath",
                    value=getClassPath,
                    ns="cloudRmpi");
  
  assignInNamespace(x="ppe.getNetworkNames",
                    value=ppe.getNetworkNames,
                    ns="cloudRmpi")
                    
}
