/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.gui;

import com.norbl.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class SwingDefaults {
    public static Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static Font DEFAULT_BOLD_FONT = new Font("SansSerif", 1, 12);
    public static Font MENU_FONT = new Font("SansSerif", 0, 12);

    public static void setDefaults() throws Exception {
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        UIDefaults uids = UIManager.getDefaults();
        uids.put("Table.background", Color.white);
        uids.put("ScrollPane.background", Color.white);
        uids.put("Panel.background", Color.white);
        uids.put("Viewport.background", Color.white);
        uids.put("RadioButton.background", Color.white);
        uids.put("MenuItem.font", MENU_FONT);
        uids.put("Menu.font", MENU_FONT);
        uids.put("OptionPane.questionDialog.titlePane.background", Color.white);
        uids.put("OptionPane.warningDialog.titlePane.background", Color.white);
        uids.put("OptionPane.background", Color.white);
        uids.put("OptionPane.questionDialog.border.background", Color.white);
        uids.put("OptionPane.questionDialog.titlePane.background", Color.white);
        uids.put("InternalFrame.optionDialogBorder", Color.white);
        uids.put("OptionPane.background", Color.white);
        uids.put("OptionPane.questionDialog.border.background", Color.white);
        uids.put("OptionPane.font", DEFAULT_FONT);
        uids.put("Label.font", DEFAULT_FONT);
    }

    public static void getDefaults(String keyPattern) {
        SwingDefaults.getDefaults(UIManager.getDefaults(), keyPattern);
        SwingDefaults.getDefaults(UIManager.getLookAndFeelDefaults(), keyPattern);
    }

    public static void getDefaults(UIDefaults defs, String keyPattern) {
        Enumeration e = defs.keys();
        while (e.hasMoreElements()) {
            Object x = e.nextElement();
            if (x instanceof String) {
                String k = (String)x;
                if ((keyPattern == null || !k.toLowerCase().contains(keyPattern)) && keyPattern != null) continue;
                System.out.println(k + "  " + defs.get(k));
                continue;
            }
            System.out.println("? " + x + "  " + defs.get(x));
        }
    }

    public static void setIcon(JFrame f) {
        try {
            ImageIcon icon = new ImageIcon(f.getClass().getResource("/com/norbl/util/gui/nbl_logo_icon_size_15_b.jpg"));
            f.setIconImage(icon.getImage());
        }
        catch (Exception xx) {
            System.err.println(StringUtil.toString(xx));
        }
    }

    public static ImageIcon getNblIcon() {
        try {
            return new ImageIcon(SwingDefaults.class.getResource("/com/norbl/util/gui/nbl_logo_icon_size_15_b.jpg"));
        }
        catch (Exception xx) {
            System.err.println(StringUtil.toString(xx));
            return null;
        }
    }

    static void testAll() throws Exception {
    }

    public static void main(String[] argv) throws Exception {
        SwingDefaults.getDefaults("label");
    }
}

