/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.ssh;

import com.norbl.util.gui.SwingDefaults;
import com.norbl.util.ssh.SshMinimalShell;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;

public class SshMinimalShellFrame
extends JFrame {
    WevHandler wevh;
    SshMinimalShell parent;
    boolean disposed;
    private JLabel helpLabel;
    private JScrollPane inputSP;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane outputSP;
    private JTextArea stderrJTextArea;
    private JScrollPane stderrSP;
    private JTextArea stdinJTextArea;
    private JTextArea stdoutJJTextArea;

    public SshMinimalShellFrame(String hostName, SshMinimalShell parent) {
        this.parent = parent;
        this.disposed = false;
        this.wevh = new WevHandler();
        this.addWindowListener(this.wevh);
        this.initComponents();
        SwingDefaults.setIcon(this);
        this.setTitle("ssh to " + hostName);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(1200000);
        this.helpLabel.setToolTipText(SshMinimalShell.helpTT);
        this.setStdoutScrollDown();
        this.setStderrScrollDown();
        this.setVisible(true);
    }

    public void setStdoutScrollDown() {
        ((DefaultCaret)this.stdoutJJTextArea.getCaret()).setUpdatePolicy(2);
    }

    public void setStderrScrollDown() {
        ((DefaultCaret)this.stderrJTextArea.getCaret()).setUpdatePolicy(2);
    }

    public void appendOutput(String s) {
        this.stdoutJJTextArea.append(s);
    }

    public Document getStdinDoc() {
        return this.stdinJTextArea.getDocument();
    }

    public void appendToStdin(String s) {
        this.stdinJTextArea.append(s);
    }

    public void setInputKeyListener(KeyListener kl) {
        this.stdinJTextArea.addKeyListener(kl);
    }

    private void initComponents() {
        this.stderrSP = new JScrollPane();
        this.stderrJTextArea = new JTextArea();
        this.outputSP = new JScrollPane();
        this.stdoutJJTextArea = new JTextArea();
        this.inputSP = new JScrollPane();
        this.stdinJTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.helpLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.stderrJTextArea.setColumns(20);
        this.stderrJTextArea.setEditable(false);
        this.stderrJTextArea.setRows(5);
        this.stderrSP.setViewportView(this.stderrJTextArea);
        this.stdoutJJTextArea.setColumns(20);
        this.stdoutJJTextArea.setEditable(false);
        this.stdoutJJTextArea.setRows(5);
        this.outputSP.setViewportView(this.stdoutJJTextArea);
        this.stdinJTextArea.setColumns(20);
        this.stdinJTextArea.setRows(5);
        this.inputSP.setViewportView(this.stdinJTextArea);
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel1.setText("stderr");
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel2.setText("stdout");
        this.jLabel3.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel3.setText("stdin");
        this.helpLabel.setText("help");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stderrSP, -1, 595, Short.MAX_VALUE).addComponent(this.outputSP).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.inputSP).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.helpLabel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.helpLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stderrSP, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.outputSP, -2, 438, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputSP, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SshMinimalShellFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SshMinimalShellFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SshMinimalShellFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SshMinimalShellFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    class WevHandler
    extends WindowAdapter {
        WevHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (!SshMinimalShellFrame.this.disposed) {
                new Thread(){

                    @Override
                    public void run() {
                        if (SshMinimalShellFrame.this.parent != null) {
                            SshMinimalShellFrame.this.parent.shutdown();
                        }
                    }
                }.start();
                SshMinimalShellFrame.this.dispose();
                SshMinimalShellFrame.this.disposed = true;
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (!SshMinimalShellFrame.this.disposed) {
                new Thread(){

                    @Override
                    public void run() {
                        if (SshMinimalShellFrame.this.parent != null) {
                            SshMinimalShellFrame.this.parent.shutdown();
                        }
                    }
                }.start();
                SshMinimalShellFrame.this.dispose();
                SshMinimalShellFrame.this.disposed = true;
            }
        }
    }
}

