% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.clogitLasso.R
\name{plot.clogitLasso}
\alias{plot.clogitLasso}
\title{Plot coefficients from a \code{clogitLasso} object}
\usage{
\method{plot}{clogitLasso}(x, logLambda = TRUE, add.legend = FALSE,
  add.labels = TRUE, lty = 1:ncol(x$beta), col = 1:ncol(x$beta), ...)
}
\arguments{
\item{x}{an objet of type \code{clogitLasso}}

\item{logLambda}{Set to  TRUE if the horizontal axis is on log scale}

\item{add.legend}{Take the value TRUE if legend should be printed in top right hand corner}

\item{add.labels}{set to TRUE if labels are to be added to curves at leftmost side}

\item{lty}{Same to \code{lty} parameter of plot function}

\item{col}{Same to \code{col} parameter of plot function}

\item{...}{additional arguments to plot function}
}
\description{
Plot the parameter profile associated \code{clogitLasso} object
}
\examples{
#generate data
 y = rep(c(1,0), 100)
 X = matrix (rnorm(20000, 0, 1), ncol = 100) # pure noise
 strata = sort(rep(1:100, 2))

 fitLasso = clogitLasso(X,y,strata,log=TRUE)
 # plot
 plot(fitLasso)
}
\author{
Marius Kwemou and Marta Avalos
}
\references{
Avalos, M., Pouyes, H., Grandvalet, Y., Orriols, L., & Lagarde, E. (2015). \emph{Sparse conditional logistic
 regression for analyzing large-scale matched data from epidemiological studies: a simple algorithm.} BMC bioinformatics, 16(6), 1.
}

