% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project-update-estimate}
\alias{project-update-estimate}
\alias{project_update_estimate_time}
\alias{project_update_estimate_budget}
\title{Update project time & budget estimates}
\usage{
project_update_estimate_time(
  project_id,
  estimate = NULL,
  manual = TRUE,
  active = TRUE,
  monthly = FALSE
)

project_update_estimate_budget(
  project_id,
  estimate = NULL,
  manual = TRUE,
  active = TRUE,
  monthly = FALSE
)
}
\arguments{
\item{project_id}{Project ID}

\item{estimate}{Updated estimate}

\item{manual}{Is the estimate for the whole project (\code{TRUE}) or should task-base estimate be enabled (\code{FALSE}).}

\item{active}{Activate this estimate. Only one of either time or budget estimate may be active.}

\item{monthly}{Should estimate be reset monthly?}
}
\description{
Update project time & budget estimates

Only available on a paid plan.
}
\examples{
\dontrun{
project_update_estimate_time("612b16c0bc325f120a1e5099", "PT1H0M0S", TRUE, TRUE)
}
\dontrun{
project_update_estimate_budget("612b16c0bc325f120a1e5099", 1000, TRUE, TRUE)
}
}
