% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clipboard.R
\name{write_clip}
\alias{write_clip}
\title{Write clipboard}
\usage{
write_clip(content, object_type = c("auto", "character", "table"),
  breaks = NULL, eos = NULL, return_new = TRUE, ...)
}
\arguments{
\item{content}{An object to be written to the system clipboard.}

\item{object_type}{write_clip() tries to be smart about writing objects in a
useful manner. If passed a data.frame or matrix, it will format it using
\code{\link{write.table}} for pasting into an external spreasheet program.
It will otherwise coerce the object to a character vector. \code{auto} will
check the object type, otherwise \code{table} or \code{character} can be
explicitly specified.}

\item{breaks}{The separator to be used between each element of the character
vector being written. \code{NULL} defaults to writing system-specific line
breaks between each element of a character vector, or each row of a table.}

\item{eos}{The terminator to be written after each string, followed by an
ASCII \code{nul}. Defaults to no terminator character, indicated by
\code{NULL}.}

\item{return_new}{If true, returns the rendered string; if false, returns the
original object}

\item{...}{Custom options to be passed to \code{\link{write.table}} (if the
  object is a table-like) Defaults to
  sane line-break and tab standards based on the operating system.}
}
\value{
Invisibly returns the original object
}
\description{
Write a character vector to the system clipboard
}
\examples{
text <- "Write to clipboard"
write_clip(text)

multiline <- c("Write", "to", "clipboard")
write_clip(multiline)
# Write
# to
# clipboard

write_clip(multiline, breaks = ",")
# write,to,clipboard

tbl <- data.frame(a=c(1,2,3), b=c(4,5,6))
write_clip(tbl)
}

