% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_monogenic.R
\name{trans_monogenic}
\alias{trans_monogenic}
\title{The transmission matrix for a common genetic model}
\usage{
trans_monogenic(n_alleles, annotate = FALSE)
}
\arguments{
\item{n_alleles}{A positive integer, interpreted as the number of possible
alleles at the genetic locus.}

\item{annotate}{A logical flag. When \code{FALSE} (the default), the function
returns a matrix suitable to be used as the \code{trans} argument of
\code{\link{pedigree_loglikelihood}}. When \code{TRUE}, the function annotates
this matrix (and converts it to a data frame) to make the output more
easily understood by humans.}
}
\value{
Either a matrix of genetic transmission probabilities suitable to be
used as the \code{trans} argument of \code{\link{pedigree_loglikelihood}}
(if \code{annotate} is \code{FALSE}), or a data frame that is an annotated version of
this matrix (if \code{annotate} is \code{TRUE}).
}
\description{
A function to calculate the transmission matrix for a single autosomal
genetic locus with an arbitrary number of alleles and unphased genotypes,
based on Mendel's laws of inheritance.
}
\details{
When \code{annotate} is \code{FALSE}, a matrix of genetic transmission
probabilities is returned, with rows corresponding to the possible joint
parental genotypes and columns corresponding to the possible offspring
genotypes.
There are \code{ngeno = n_alleles*(n_alleles + 1)/2} possible unphased genotypes,
and by choosing an order on these genotypes (see below) we can take the set
of possible genotypes to be \code{1:ngeno}.
Then the \verb{(ngeno * gm + gf - ngeno, go)}th element of the outputted matrix is
the conditional probability that a person has genotype \code{go}, given that his
or her biological mother and father have genotypes \code{gm} and \code{gf},
respectively.
When \code{annotate} is \code{TRUE}, the function converts this matrix to a data frame,
adds column names giving the offspring genotype corresponding to each
column, and adds columns \code{gm} and \code{gf} describing the parental genotypes
corresponding to each row.
In this data frame, all genotypes are written in the usual form
\verb{1/1, 1/2, ...} for alleles \code{1:n_alleles}, so these
annotations show the genotype order referred to above.
Note that if the output of this function is to be used as the \code{trans}
argument of \code{\link{pedigree_loglikelihood}} then the \code{annotate} option
must be set to \code{FALSE}.
}
\examples{
# The transition matrix for a biallelic, autosomal locus with unphased genotypes
trans_monogenic(2)
trans_monogenic(2, annotate = TRUE)

}
