% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-tableClinData.R
\name{tableClinData}
\alias{tableClinData}
\title{Create a 'clinical data table', associated to a plot.}
\usage{
tableClinData(
  data,
  idVar = "USUBJID",
  idLab = getLabelVar(idVar, labelVars = labelVars),
  keyVar = NULL,
  keyLab = getLabelVar(keyVar, labelVars = labelVars),
  pathVar = NULL,
  pathLab = getLabelVar(pathVar, labelVars = labelVars),
  pathExpand = FALSE,
  tableVars = colnames(data),
  tableLab = getLabelVar(tableVars, labelVars = labelVars),
  tableButton = TRUE,
  tablePars = list(),
  id = paste0("plotClinData", sample.int(n = 1000, size = 1)),
  labelVars = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{idVar}{String with variable containing subject ID.}

\item{idLab}{String with label for \code{idVar}.}

\item{keyVar}{String with unique key variable, identifying unique
group for which the link between the table and the plot should be done.}

\item{keyLab}{String with label for \code{keyVar}.}

\item{pathVar}{String with variable of \code{data} containing hyperlinks 
with path to the subject-specific report, formatted as: \cr
\preformatted{<a href="./path-to-report">label</a>}.\cr 
If multiple, they should be separated by: ', '.\cr
The report(s) will be:
\itemize{
\item compressed to a zip file and downloaded 
if the user clicks on the 'p' (a.k.a 'profile') key
when hovering on a point of the plot
\item included in a collapsible row, and clickable with hyperlinks
in the table
}}

\item{pathLab}{String with label for \code{pathVar},
included in the collapsible row in the table.}

\item{pathExpand}{Logical, should the variable in \code{pathExpand}
be included in a collapsible row or as hyperlink in the table?
Should be TRUE for if multiple paths are included for each \code{idVar},
FALSE otherwise (by default).}

\item{tableVars}{Character vector with variables to be included 
in the table.}

\item{tableLab}{Named character vector with labels
for each \code{tableVars}.}

\item{tableButton}{Logical, if TRUE (by default)
the table is included within an HTML button.}

\item{tablePars}{List with parameters passed to the
\code{\link[clinUtils]{getClinDT}} function.}

\item{id}{String with general id for the plot:
\itemize{
\item 'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}
\item 'button:[id]' is used as button ID if \code{table} is TRUE
}
If not specified, a random id, as 'plotClinData[X]' is used.}

\item{labelVars}{Named character vector containing variable labels.}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
in the current console.}
}
\value{
\code{\link[DT]{datatable}}
}
\description{
Interactive table is created, with the possibility to have
clickeable link to patient-specific report, and included
within a button.
}
\author{
Laure Cougnaud
}
