% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-md.R
\name{renderChapter}
\alias{renderChapter}
\title{Render one chapter of a clinical report, based on a configuration
file}
\usage{
renderChapter(
  configFile,
  configGeneralParams = getParamsFromConfig(configFile = "config.yml", configDir =
    configDir, inputDir = inputDir),
  configDir = file.path(inputDir, "config"),
  indexPath = file.path(inputDir, "index.Rmd"),
  inputDir = ".",
  intermediateDir = "./interim",
  logFile = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{configFile}{String with filename of the config
file of interest in YAML format.}

\item{configGeneralParams}{List with parameters from the general config file}

\item{configDir}{String with directory with config files,
by default a 'config' folder in \code{inputDir}.\cr
It should contain a general 'config.yml' file and dedicated
'config-[X].yml' for each chapter.
The order of each chapter is specified in the 'config' slot in the general 
general 'config.yml'.}

\item{indexPath}{String with path to the index file,
by default 'index.Rmd' in \code{inputDir}.}

\item{inputDir}{String with input directory,
working directory by default.}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}

\item{logFile}{(optional) String with path to a log file,
where output (also error/messages/warnings) should be stored.
If specified, the entire output is re-directed to this file.}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
during the report execution.}

\item{...}{options passed to \code{\link{renderFile}}}
}
\value{
No output file, the Markdown report for the chapter
and the \code{knit_meta} object is available in the
\code{intermediateDir} directory.\cr
If the input parameters are not correctly extracted, NULL is returned.
}
\description{
Render one chapter of a clinical report, based on a configuration
file
}
