% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress-variables.R
\name{progress-variables}
\alias{progress-variables}
\alias{pb_bar}
\alias{pb_current}
\alias{pb_current_bytes}
\alias{pb_elapsed}
\alias{pb_elapsed_clock}
\alias{pb_elapsed_raw}
\alias{pb_eta}
\alias{pb_eta_raw}
\alias{pb_eta_str}
\alias{pb_extra}
\alias{pb_id}
\alias{pb_name}
\alias{pb_percent}
\alias{pb_pid}
\alias{pb_rate}
\alias{pb_rate_raw}
\alias{pb_rate_bytes}
\alias{pb_spin}
\alias{pb_status}
\alias{pb_timestamp}
\alias{pb_total}
\alias{pb_total_bytes}
\title{Progress bar variables}
\description{
Progress bar variables
}
\details{
These variables can be used in cli progress bar format strings.
\itemize{
\item \code{pb_bar} creates a visual progress bar. If the number of total units
is unknown, then it will return an empty string.
\item \code{pb_current} is the number of current progress units.
\item \code{pb_current_bytes} is the number of current progress utils formatted
as bytes. The output has a constant width of six characters.
\item \code{pb_elapsed} is the elapsed time since the start of the progress
bar. The time is measured since the progress bar is created with
\code{\link[=cli_progress_bar]{cli_progress_bar()}} or similar.
\item \code{pb_elapsed_clock} is the elapsed time, in hh::mm::ss format.
\item \code{pb_elapsed_raw} is the number of seconds since the start of the
progress bar.
\item \code{pb_eta} is the estimated time until the end of the progress bar,
in human readable form.
\item \code{pb_eta_raw} is the estimated time until the end of the progress
bar, in seconds.
\item \code{pb_eta_str} is the estimated time until the end of the progress bar.
It includes the \code{"ETA:"} prefix. It is only shown if the time can be
estimated, otherwise it is the empty string.
\item \code{pb_extra} can be used to access extra data, see the \code{extra} argument
of \code{cli_progress_bar()} and \code{cli_progress_update()}.
\item \code{pb_id} is the id of the progress bar. The id has the format
\verb{cli-<pid>-<counter>} where \verb{<pid>} is the process id, and
\verb{<counter>} is an integer counter that is incremented every time
cli needs a new unique id.
\item \code{pb_name} is the name of the progress bar. This is supplied by the
developer, and it is by default the empty string. A space character
is added to non-empty names.
\item \code{pb_percent} is the percentage of the progress bar, always formatted
in three characters plus the percentage sign. If the total number of
units is unknown, then it is \code{" NA\%"}.
\item \code{pb_pid} is the integer process id of the progress bar.
\item \code{pb_rate} is the progress rate, in number of units per second,
formatted in a string.
\item \code{pb_rate_raw} is the raw progress rate, in number of units per second.
\item \code{pb_rate_bytes} is the progress rate, formatted as bytes per second,
in human readable form.
\item \code{pb_spin} is a spinner. The default spinner is selected via a
\code{\link[=get_spinner]{get_spinner()}} call.
\item \code{pb_status} is the status string of the progress bar. By default this
is an empty string, but it is possible to set it in \code{\link[=cli_progress_bar]{cli_progress_bar()}}
and `cli_progress_update()].
\item \code{pb_timestamp} is a time stamp in ISO 8601 format.
\item \code{pb_total} is the total number of progress units, or \code{NA} if the number
of units is unknown.
\item \code{pb_total_bytes} is the total number of progress units, formatted as
bytes, in a human readable format.
}
}
\examples{
# pb_bar and pb_percent
cli_progress_demo(
  format = "Progress bar: {cli::pb_bar} {cli::pb_percent}",
  total = 100
)

# pb_current and pb_total
cli_progress_demo(
  format = "[{cli::pb_current}/{cli::pb_total}]",
  total = 248
)

# pb_current_bytes, pb_total_bytes
cli_progress_demo(
  format = "[{cli::pb_current_bytes}/{cli::pb_total_bytes}]",
  total = 102800,
  at = seq(0, 102800, by = 1024)
)
}
