% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{cli_vec}
\alias{cli_vec}
\title{Add custom cli style to a vector}
\usage{
cli_vec(x, style = list())
}
\arguments{
\item{x}{Vector that will be collapsed by cli.}

\item{style}{Style to apply to the vector. It is used as a theme on
a \code{span} element that is created for the vector. You can set \code{vec_sep}
and \code{vec_last} to modify the \code{sep} and \code{last} arguments of
\code{\link[glue:glue_collapse]{glue::glue_collapse()}}. See an example below.}
}
\description{
Add custom cli style to a vector
}
\details{
You can use this function to change the default parameters of
\code{\link[glue:glue_collapse]{glue::glue_collapse()}}, see an example below.

The style is added as an attribute, so operations that remove
attributes will remove the style as well.
}
\examples{
v <- cli_vec(
  c("foo", "bar", "foobar"),
  style = list(vec_sep = " & ", vec_last = " & ")
)
cli_text("My list: {v}.")
}
\seealso{
\code{\link[=cli_format]{cli_format()}}
}
