% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_clusterings.R
\name{completeness}
\alias{completeness}
\title{Completeness Between Clusterings}
\usage{
completeness(true, pred)
}
\arguments{
\item{true}{ground truth clustering represented as a membership
vector. Each entry corresponds to an element and the value identifies
the assigned cluster. The specific values of the cluster identifiers
are arbitrary.}

\item{pred}{predicted clustering represented as a membership
vector.}
}
\description{
Computes the completeness between two clusterings, such
as a predicted and ground truth clustering.
}
\details{
Completeness is an entropy-based measure of the similarity
between two clusterings, say \eqn{t} and \eqn{p}. The completeness
is high if \emph{all} members of a given cluster in \eqn{t} are assigned
to a single cluster in \eqn{p}. The completeness ranges between 0
and 1, where 1 indicates perfect completeness.
}
\examples{
true <- c(1,1,1,2,2)  # ground truth clustering
pred <- c(1,1,2,2,2)  # predicted clustering
completeness(true, pred)

}
\references{
Rosenberg, A. and Hirschberg, J. "V-measure: A conditional entropy-based external cluster evaluation measure." \emph{Proceedings of the 2007 Joint Conference on Empirical Methods in Natural Language Processing and Computational Natural Language Learning} (EMNLP-CoNLL), (2007).
}
\seealso{
\code{\link{homogeneity}} evaluates the \emph{homogeneity}, which is a dual
measure to \emph{completeness}. \code{\link{v_measure}} evaluates the harmonic mean of
\emph{completeness} and \emph{homogeneity}.
}
