% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{check_directory}
\alias{check_directory}
\title{Check a Directory}
\usage{
check_directory(path, pattern = "\\\\.[rR]$", recursive = FALSE, ...)
}
\arguments{
\item{path}{Path to the directory to be checked.}

\item{pattern}{A pattern to search files with, see \code{\link{list.files}}.}

\item{recursive}{Search the directory recursively?
See \code{\link{list.files}}.}

\item{...}{Arguments to be passed to \code{\link{check_file}}.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \code{\link{TRUE}},
but see \emph{Details}.
}
\description{
Run \code{\link{check_file}} on files in a directory.
}
\details{
The function catches the messages of "cleanr"-conditions
\code{\link{throw}}n by \code{\link{check_file}} and, if it caught any,
\code{\link{throw}}s them.
}
\examples{
# load internal functions first.
load_internal_functions("cleanr")
print(cleanr::check_directory(system.file("source", "R", package = "cleanr"),
                              max_num_arguments = 8, max_file_width = 90,
                              max_file_length = 350,
                              check_return = FALSE))
}
\seealso{
\code{\link{check_package}}.
}
