% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_setx.R
\name{sim_setx}
\alias{sim_setx}
\alias{print.clarify_setx}
\title{Compute predictions and first differences at set values}
\usage{
sim_setx(
  sim,
  x = list(),
  x1 = list(),
  outcome = NULL,
  type = NULL,
  verbose = TRUE,
  cl = NULL
)

\method{print}{clarify_setx}(x, digits = NULL, max.ests = 6, ...)
}
\arguments{
\item{sim}{a \code{clarify_sim} object; the output of a call to \code{\link[=sim]{sim()}} or
\code{\link[=misim]{misim()}}.}

\item{x}{a data.frame containing a reference grid of predictor values or a named list of values each predictor should take defining such a
reference grid, e.g., \code{list(v1 = 1:4, v2 = c("A", "B"))}.
Any omitted predictors are fixed at a "typical" value. See Details.
When \code{x1} is specified, \code{x} should identify a single reference unit.

For \code{print()}, a \code{clarify_setx} object.}

\item{x1}{a data.frame or named list of the value each predictor should take to compute the
first difference from the predictor combination specified in \code{x}. \code{x1} can
only identify a single unit. See Details.}

\item{outcome}{a string containing the name of the outcome or outcome level for multivariate (multiple outcomes) or multi-category outcomes. Ignored for univariate (single outcome) and binary outcomes.}

\item{type}{a string containing the type of predicted values (e.g., the link or the response). Passed to \code{\link[marginaleffects:get_predict]{marginaleffects::get_predict()}} and eventually to \code{predict()} in most cases. The default and allowable option depend on the type of model supplied, but almost always corresponds to the response scale (e.g., predicted probabilities for binomial models).}

\item{verbose}{\code{logical}; whether to display a text progress bar indicating
progress and estimated time remaining for the procedure. Default is \code{TRUE}.}

\item{cl}{a cluster object created by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}, or an
integer to indicate the number of child-processes (integer values are
ignored on Windows) for parallel evaluations. See \code{\link[pbapply:pbapply]{pbapply::pblapply()}} for
details. If \code{NULL}, no parallelization will take place.}

\item{digits}{the minimum number of significant digits to be used; passed to \code{\link[=print.data.frame]{print.data.frame()}}.}

\item{max.ests}{the maximum number of estimates to display.}

\item{...}{optional arguments passed to \code{FUN}.}
}
\value{
a \code{clarify_setx} object, which inherits from \code{clarify_est} and is similar to the output of \code{sim_apply()}, with the following additional attributes:
\itemize{
\item \code{"setx"} - a data frame containing the values at which predictions are to be made
\item \code{"fd"} - whether or not the first difference is to be computed; set to \code{TRUE} if \code{x1} is specified and \code{FALSE} otherwise
}
}
\description{
\code{sim_setx()} is a wrapper for \code{\link[=sim_apply]{sim_apply()}} that computes predicted values of
the outcome at specified values of the predictors, sometimes called marginal
predictions. One can also compute the difference between two marginal
predictions (the "first difference"). Although any function that accepted
\code{clarify_est} objects can be used with \code{sim_setx()} output objects, a
special plotting function, \code{\link[=plot.clarify_setx]{plot.clarify_setx()}}, can be used to plot marginal
predictions.
}
\details{
When \code{x} is a named list of predictor values, they will be crossed
to form a reference grid for the marginal predictions. Any predictors not
set in \code{x} are assigned their "typical" value, which, for factor,
character, logical, and binary variables is the mode, for numeric variables
is the mean, and for ordered variables is the median. These values can be
seen in the \code{"setx"} attribute of the output object. If \code{x} is empty, a
prediction will be made at a point corresponding to the typical value of
every predictor. Estimates are identified (in \code{summary()}, etc.) only by
the variables that differ across predictions.

When \code{x1} is supplied, the first difference is computed, which here is
considered as the difference between two marginal predictions. One marginal
prediction must be specified in \code{x} and another, ideally with a single
predictor changed, specified in \code{x1}.
}
\examples{
data("lalonde", package = "MatchIt")

fit <- lm(re78 ~ treat + age + educ + married + race + re74,
          data = lalonde)

# Simulate coefficients
set.seed(123)
s <- sim(fit, n = 100)

# Predicted values at specified values of values, typical
# values for other predictors
est <- sim_setx(s, x = list(treat = 0:1,
                            re74 = c(0, 10000)),
                verbose = FALSE)
summary(est)
plot(est)

# Predicted values at specified grid of values, typical
# values for other predictors
est <- sim_setx(s, x = list(age = c(20, 25, 30, 35),
                            married = 0:1),
                verbose = FALSE)
summary(est)
plot(est)

# First differences of treat at specified value of
# race, typical values for other predictors
est <- sim_setx(s, x = data.frame(treat = 0, race = "hispan"),
                x1 = data.frame(treat = 1, race = "hispan"),
                verbose = FALSE)
summary(est)
plot(est)

}
\seealso{
\code{\link[=sim_apply]{sim_apply()}}, which provides a general interface to computing any
quantities for simulation-based inference; \code{\link[=plot.clarify_setx]{plot.clarify_setx()}} for plotting the
output of a call to \code{sim_setx()}; \code{\link[=summary.clarify_est]{summary.clarify_est()}} for computing
p-values and confidence intervals for the estimated quantities.
}
