% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{permission_sets_list}
\alias{permission_sets_list}
\title{List Permission Sets}
\usage{
permission_sets_list(
  archived = NULL,
  author = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{archived}{string optional. The archival status of the requested item(s).}

\item{author}{string optional. If specified, return items from any of these authors. It accepts a comma-separated list of user IDs.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for this permission set.}
\item{name}{string, The name of this permission set.}
\item{description}{string, A description of this permission set.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{archived}{string, The archival status of the requested item(s).}
}
\description{
List Permission Sets
}
