% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{workflows_post_executions_retry}
\alias{workflows_post_executions_retry}
\title{Retry a failed task, or all failed tasks in an execution}
\usage{
workflows_post_executions_retry(id, execution_id, task_name = NULL)
}
\arguments{
\item{id}{integer required. The ID for the workflow.}

\item{execution_id}{integer required. The ID for the workflow execution.}

\item{task_name}{string optional. If specified, the name of the task to be retried. If not specified, all failed tasks in the execution will be retried.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for this workflow execution.}
\item{state}{string, The state of this workflow execution.}
\item{mistralState}{string, The state of this workflow as reported by mistral. One of running, paused, success, error, or cancelled}
\item{mistralStateInfo}{string, The state info of this workflow as reported by mistral.}
\item{user}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{definition}{string, The definition of the workflow for this execution.}
\item{input}{object, The dictionary of name/value input pairs defined for this execution.}
\item{includedTasks}{array, The subset of workflow tasks selected to execute.}
\item{tasks}{array, An array containing the following fields: 
\itemize{
\item name string, The name of the task.
\item mistralState string, The state of this task. One of idle, waiting, running, delayed, success, or error
\item mistralStateInfo string, Extra info associated with the state of the task.
\item runs array, The runs associated with this task, in descending order by id.
\item executions array, The executions run by this task, in descending order by id.
}}
\item{startedAt}{string, The time this execution started.}
\item{finishedAt}{string, The time this execution finished.}
\item{createdAt}{string, The time this execution was created.}
\item{updatedAt}{string, The time this execution was last updated.}
}
\description{
Retry a failed task, or all failed tasks in an execution
}
