% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{reports_list}
\alias{reports_list}
\title{List}
\usage{
reports_list(type = NULL, author = NULL, template_id = NULL,
  hidden = NULL, archived = NULL, limit = NULL, page_num = NULL,
  order = NULL, order_dir = NULL)
}
\arguments{
\item{type}{string optional. If specified, return report of these types. It accepts a comma-separated list, possible values are 'tableau' or 'other'.}

\item{author}{string optional. If specified, return reports from this author. It accepts a comma-separated list of author ids.}

\item{template_id}{integer optional. If specified, return reports using the provided Template.}

\item{hidden}{boolean optional. If specified to be true, returns hidden objects. Defaults to false, returning non-hidden objects.}

\item{archived}{string optional. The archival status of the requested object(s).}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of this report.}
\item{name}{string, The name of the report.}
\item{user}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{projects}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID for the project.
\item name string, The name of the project.
}}
\item{state}{string, The status of the report's last run.}
\item{finishedAt}{string, The time that the report's last run finished.}
\item{vizUpdatedAt}{string, The time that the report's visualization was last updated.}
\item{script}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID for the script.
\item name string, The name of the script.
\item sql string, The raw SQL query for the script.
}}
\item{jobPath}{string, The link to details of the job that backs this report.}
\item{tableauId}{integer, }
\item{type}{string, }
\item{templateId}{integer, The ID of the template used for this report.}
\item{authThumbnailUrl}{string, URL for a thumbnail of the report.}
\item{lastRun}{object, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{archived}{string, The archival status of the requested object(s).}
}
\description{
List
}
