% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{databases_list_tables_search}
\alias{databases_list_tables_search}
\title{List tables in the specified database, deprecated use "GET /tables" instead}
\usage{
databases_list_tables_search(id, name = NULL, column_name = NULL)
}
\arguments{
\item{id}{integer required. The ID of the database.}

\item{name}{string optional. If specified, will be used to filter the tables returned. Substring matching is supported (e.g., "name=table" will return both "table1" and "my table").}

\item{column_name}{string optional. Search for tables containing a column with the given name.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the table.}
\item{databaseId}{integer, The ID of the database.}
\item{schema}{string, The name of the schema containing the table.}
\item{name}{string, Name of the table.}
\item{description}{string, The description of the table, as specified by the table owner}
\item{isView}{boolean, True if this table represents a view. False if it represents a regular table.}
\item{rowCount}{integer, The number of rows in the table.}
\item{columnCount}{integer, The number of columns in the table.}
\item{sizeMb}{number, The size of the table in megabytes.}
\item{owner}{string, The database username of the table's owner.}
\item{distkey}{string, The column used as the Amazon Redshift distkey.}
\item{sortkeys}{string, The column used as the Amazon Redshift sortkey.}
\item{refreshStatus}{string, How up-to-date the table's statistics on row counts, null counts, distinct counts, and values distributions are. One of: refreshing, stale, or current.}
\item{lastRefresh}{string, The time of the last statistics refresh.}
\item{refreshId}{string, The ID of the most recent statistics refresh.}
\item{lastRun}{object, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{columnNames}{array, The names of each column in the table.}
}
\description{
List tables in the specified database, deprecated use "GET /tables" instead
}
