% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDP.R
\name{PDP}
\alias{PDP}
\title{Partial Dependence Plot (PDP)}
\usage{
PDP(
  model,
  variable = NULL,
  data = NULL,
  ice = FALSE,
  resolution.ice = 20,
  plot = TRUE
)
}
\arguments{
\item{model}{a model created by \code{\link{dnn}}}

\item{variable}{variable as string for which the PDP should be done. If none is supplied it is done for all variables.}

\item{data}{specify new data PDP should be performed . If NULL, PDP is performed on the training data.}

\item{ice}{Individual Conditional Dependence will be shown if TRUE}

\item{resolution.ice}{resolution in which ice will be computed}

\item{plot}{plot ALE or not}
}
\value{
A list of plots made with 'ggplot2' consisting of an individual plot for each defined variable.
}
\description{
Calculates the Partial Dependency Plot for one feature, either numeric or categorical. Returns it as a plot.
}
\details{
Performs the estimation of the partial function \eqn{\hat{f}_S}{}

\eqn{\hat{f}_S(x_S)=\frac{1}{n}\sum_{i=1}^n\hat{f}(x_S,x^{(i)}_{C})}{}

with a Monte Carlo Estimation:

\eqn{\hat{f}_S(x_S)=\frac{1}{n}\sum_{i=1}^n\hat{f}(x_S,x^{(i)}_{C})}{}

If a categorical feature is analyzed, all data instances are used and set to each level.
Then an average is calculated per category and put out in a bar plot.

If ice is set to true additional the individual conditional dependence will be shown and the original PDP will be colored yellow.
These lines show, how each individual data sample reacts to changes in the feature. This option is not available for categorical features.
Unlike PDP the ICE curves are computed with a value grid instead of utilizing every value of every data entry.
}
\examples{
\donttest{
if(torch::torch_is_installed()){
library(cito)

# Build and train  Network
nn.fit<- dnn(Sepal.Length~., data = datasets::iris)

PDP(nn.fit, variable = "Petal.Length")
}
}
}
\seealso{
\code{\link{ALE}}
}
